#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"
#include <ode/ode.h>
#include "tworld.h"
#include "tcontact.h"
#include "tjoint.h"
#include "odehelper.h"



IMPLEMENT_CO_DATABLOCK_V1(tdWorldData);

tdWorldData::tdWorldData()
{
}

tdWorldData::~tdWorldData()
{
}


void tdWorldData::consoleInit()
{
	Parent::consoleInit();
}

void tdWorldData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdWorldData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdWorldData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdWorldData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdWorld);


tdWorld::tdWorld() {
	mNetFlags.set(ScopeAlways | Ghostable);
	contactjointgroup = 0;
	world = 0;
}

tdWorld::~tdWorld() {
}

bool tdWorld::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}	
	world = dWorldCreate();
	
	if(!world) {
		return false;
	}
	
	dWorldSetERP(world, Con::getFloatVariable("$pref::ODEPhysics::Server::WorldERP"));
	dWorldSetCFM(world, Con::getFloatVariable("$pref::ODEPhysics::Server::WorldCFM"));
	dWorldSetGravity(world,
		Con::getFloatVariable("$pref::ODEPhysics::Server::WorldGravityX"),
		Con::getFloatVariable("$pref::ODEPhysics::Server::WorldGravityY"),
		Con::getFloatVariable("$pref::ODEPhysics::Server::WorldGravityZ"));
	
	if(isGhost()) {
		Con::setIntVariable("$odeworldclient", getId());
		if(0 == contactjointgroup) {
			contactjointgroup=Con::getIntVariable("$odecollisionjgclient", 0);
		}
	}
	
	return true;
}

void tdWorld::onRemove() {
	Parent::onRemove();
	if(!istorqueworld) {
		dWorldDestroy(world);
	}
	Con::removeVariable("$odeworld");
	Con::removeVariable("$odeworldclient");
	if(contactjointgroup) {
		dJointGroupEmpty(((tdJointGroup *)Sim::findObject(contactjointgroup))->group);
	}	
}

void tdWorld::consoleInit()
{
	Parent::consoleInit();
}

bool tdWorld::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdWorldData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdWorld::processTick(const Move* move)
{
	Parent::processTick(move);
	
	if((isGhost() && Con::getBoolVariable("$pref::ODEPhysics::Client::EnableODE",1)) ||
		(isServerObject() && Con::getBoolVariable("$pref::ODEPhysics::Server::EnableODE",1))) {

		for(int i=0; i<Con::getIntVariable("$pref::ODEPhysics::Server::NumWorldSteps",1); i++) {
			dWorldQuickStep(world,
							Con::getFloatVariable("$pref::ODEPhysics::Server::WorldStep",0.03));
		}
	}
		
	if(contactjointgroup) {
			dJointGroupEmpty(((tdJointGroup *)Sim::findObject(contactjointgroup))->group);
	}
}

void tdWorld::initPersistFields()
{
	Parent::initPersistFields();
	
	addField("contactjointgroup", TypeS32,
		Offset(contactjointgroup, tdWorld), "will be automatically emptied on tick");

}

void tdWorld::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdWorld::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdWorld::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	return Parent::packUpdate(conn, mask, stream);
}

void tdWorld::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
}
