#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"

#if defined HAVE_SHAPEBASE
#include "game/shapeBase.h"
#endif // defined HAVE_SHAPEBASE

#if defined HAVE_FXSCENEOBJECT2D
#include "T2D/fxSceneObject2D.h"
#endif // defined HAVE_FXSCENEOBJECT2D

#include "math/mMathFn.h"
#include "math/mQuat.h"
#include <ode/ode.h>
#include "tbody.h"
#include "tworld.h"
#include "tmass.h"
#include "odehelper.h"


ConsoleMethod(tdMass, SetZero, void, 2, 2,
	"() Initialise Mass to Zero") {

	dMassSetZero(&object->mass);
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, SetSphere, void, 4, 4,
	"(density, radius) "
	"Define the mass to be a sphere") {

	argc; argv;
	dMassSetSphere(&object->mass, dAtof(argv[2]), dAtof(argv[3]));
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, SetSphereTotal, void, 4, 4,
	"(total_mass, radius) "
	"Define the mass to be a sphere") {

	argc; argv;
	dMassSetSphereTotal(&object->mass, dAtof(argv[2]), dAtof(argv[3]));
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, SetCappedCylinder, void, 6, 6,
	"(density, direction, radius, length) "
	"Define mass to be a capped cylinder") {

	argc; argv;
	dMassSetCappedCylinder(&object->mass, dAtof(argv[2]), dAtoi(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]));
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, SetCappedCylinderTotal, void, 6, 6,
	"(total_mass, direction, radius, length) "
	"Define mass to be a capped cylinder") {

	argc; argv;
	dMassSetCappedCylinderTotal(&object->mass, dAtof(argv[2]), dAtoi(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]));
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, SetCylinder, void, 6, 6,
	"(density, direction, radius, length) "
	"Define mass to be a cylinder") {

	argc; argv;
	dMassSetCylinder(&object->mass, dAtof(argv[2]), dAtoi(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]));
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, SetCylinderTotal, void, 6, 6,
	"(total_mass, direction, radius, length) "
	"Define mass to be a cylinder") {

	argc; argv;
	dMassSetCylinderTotal(&object->mass, dAtof(argv[2]), dAtoi(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]));
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, SetBox, void, 4, 6,
	"(density, lx, ly, lz) or (density, \"lx ly lz\") "
	"Define mass to be a box") {

	argc; argv;
	float x, y, z;
	if(0 != ODEOneOrThree(argc-1,argv+1,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		dMassSetBox(&object->mass, dAtof(argv[2]), x, y, z);
		object->setMaskBits(object->NewMass);
	}
}

ConsoleMethod(tdMass, SetBoxTotal, void, 4, 6,
	"(total_mass, lx, ly, lz) or (total_mass, \"lx ly lz\") "
	"Define mass to be a box") {

	float x, y, z;
	if(0 != ODEOneOrThree(argc-1,argv+1,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		dMassSetBoxTotal(&object->mass, dAtof(argv[2]), x, y, z);
		object->setMaskBits(object->NewMass);
	}
}

ConsoleMethod(tdMass, Adjust, void, 3, 3,
	"(NewMass) "
	"Adjust mass") {

	argc; argv;
	dMassAdjust(&object->mass, dAtof(argv[2]));
	object->setMaskBits(object->NewMass);
}

ConsoleMethod(tdMass, Translate, void, 3, 5,
	"(x, y, z) or (\"x y z\") "
	"Move Mass") {

	argc; argv;
	float x, y, z;
	if(0 != ODEOneOrThree(argc-1,argv+1,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		dMassTranslate(&object->mass, x, y, z);
		object->setMaskBits(object->NewMass);
	}
}

ConsoleMethod(tdMass, SetParameters, void, 12, 12,
	"(themass, cgx, cgy, cgz, I11, I22, I33, I12, I13, I23) "
	"Set parameters on the mass") {

	argc; argv;
	dMassSetParameters(&object->mass, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]), dAtof(argv[6]),
		dAtof(argv[7]), dAtof(argv[8]), dAtof(argv[9]),
		dAtof(argv[10]), dAtof(argv[11]));
	object->setMaskBits(object->NewMass);
}

/* TODO:

dMassRotate (dMass *, const dMatrix3 R);

dMassAdd (dMass *a, const dMass *b);

*/
