#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"
#include <ode/ode.h>
#include "tcontact.h"
#include "odehelper.h"



IMPLEMENT_CO_DATABLOCK_V1(tdContactData);

tdContactData::tdContactData()
{
}

tdContactData::~tdContactData()
{
}


void tdContactData::consoleInit()
{
	Parent::consoleInit();
}

void tdContactData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdContactData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdContactData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdContactData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdContact);


tdContact::tdContact() {
	contact.surface.mode = 0;
	contact.surface.mu = 0;
	contact.surface.mu2 = 0;
	contact.surface.bounce = 0;
	contact.surface.bounce_vel = 0;
	contact.surface.soft_erp = 
		Con::getFloatVariable("$pref::ODEPhysics::Server::ContactERP");
	contact.surface.soft_cfm =
		Con::getFloatVariable("$pref::ODEPhysics::Server::ContactCFM");
	contact.surface.motion1 = 0;
	contact.surface.motion2 = 0;
	contact.surface.slip1 = 0;
	contact.surface.slip2 = 0;

	contact.geom.depth = 0;
	contact.geom.pos[0] = 0;
	contact.geom.pos[1] = 0;
	contact.geom.pos[2] = 0;
	contact.geom.normal[0] = 0;
	contact.geom.normal[1] = 0;
	contact.geom.normal[2] = 0;
	contact.geom.g1 = 0;
	contact.geom.g2 = 0;

	contact.fdir1[0] = 0;
	contact.fdir1[1] = 0;
	contact.fdir1[2] = 0;
	
	if(0 != Con::getFloatVariable("$pref::ODEPhysics::Server::SoftContact")) {
		contact.surface.mode |= dContactSoftERP;
		contact.surface.mode |= dContactSoftCFM;
	}
	
	mNetFlags.clear(Ghostable);
}

tdContact::~tdContact() {
}

bool tdContact::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	return true;
}

void tdContact::onRemove() {
	Parent::onRemove();
}

void tdContact::consoleInit()
{
	Parent::consoleInit();
}

bool tdContact::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdContactData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdContact::initPersistFields()
{
	Parent::initPersistFields();

	addField("mu", TypeF32,
		Offset(contact.surface.mu, tdContact),
		"Surface Mu");
	addField("mu2", TypeF32,
		Offset(contact.surface.mu2, tdContact),
		"Surface Mu2");
	addField("bounce", TypeF32,
		Offset(contact.surface.bounce, tdContact),
		"Surface bounce");
	addField("bounce_vel", TypeF32,
		Offset(contact.surface.bounce_vel, tdContact),
		"Surface bounce_vel");
	addField("soft_erp", TypeF32,
		Offset(contact.surface.soft_erp, tdContact),
		"Surface soft_erp");
	addField("soft_cfm", TypeF32,
		Offset(contact.surface.soft_cfm, tdContact),
		"Surface soft_cfm");
	addField("motion1", TypeF32,
		Offset(contact.surface.motion1, tdContact),
		"Surface motion1");
	addField("motion2", TypeF32,
		Offset(contact.surface.motion2, tdContact),
		"Surface motion2");
	addField("slip1", TypeF32,
		Offset(contact.surface.slip1, tdContact),
		"Surface slip1");
	addField("slip2", TypeF32,
		Offset(contact.surface.slip2, tdContact),
		"Surface slip2");
	addField("depth", TypeF32,
		Offset(contact.geom.depth, tdContact),
		"Contact depth");
}


void tdContact::processTick(const Move* move)
{
	Parent::processTick(move);
}

void tdContact::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdContact::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdContact::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	return Parent::packUpdate(conn, mask, stream);
}

void tdContact::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
}

