#!/usr/bin/perl -wT

# Don't bother trying to understand this, it would be faster to rewrite it
# I run this using (requires bournealike):

# ./methodlist.pl *.cc > methodlist.txt


while($filename = shift) {

	open(HANDLE, $filename) || next;
	print("Filename: $filename\n");

	{
		local $/; # Engage Slurp Mode
		$data = <HANDLE>;
	}

	close(HANDLE);

	while($data =~ s/ConsoleMethod\(\s*
		([^,]*),          # Object
		\s*([^,]*),       # Method Name
		\s*([^,]*),       # Return Value Type
		\s*[^,]*,       # Min Args
		\s*[^,]*,       # Max Args
		\s*([^\{]*) \{//simx) {

		$object = $1;
		$method = $2;
		$retval = $3;
		$paramsdesc = $4;

		$paramdesc = formatparam($paramdesc);

		print("Method: $retval $object" . "::$method $paramsdesc\n");
		# Because perl understands $object::
	}

	while($data =~ s/ConsoleFunction\(\s*
		\s*([^,]*),       # Function Name
		\s*([^,]*),       # Return Value Type
		\s*[^,]*,       # Min Args
		\s*[^,]*,       # Max Args
		\s*([^\{]*) \{//simx) {

		$function = $1;
		$retval = $2;
		$paramsdesc = $3;

		$paramdesc = formatparam($paramdesc);

		print("Function: $retval $function $paramsdesc\n");
	}

	print "\n\n";
}


sub formatparam {
	$paramdesc = shift;

	# turn C strings like "a" "b" into one "ab"
	$paramsdesc =~ s/"\s*"//g;

	# Remove surrounding double quotes
	$paramsdesc =~ s/"(.*)"/$1/g;

	# Remove end ) and whitespace [ie, from end of desc to open brace]
	$paramsdesc =~ s/(.*)\)\s*/$1/g;

	# Split the args and desc onto separate lines
	$paramsdesc =~ s/(.*\))\s*(.*)/$1\n\t$2/g;

	# unescape things tha have been escaped in C
	$paramsdesc =~ s/\\//g;

	return $paramdesc;
}
