#ifndef __TBODY_H
#define __TBODY_H

#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"

#if defined HAVE_SHAPEBASE
#include "game/shapeBase.h"
#include "ts/tsShapeInstance.h"
#endif // defined HAVE_SHAPEBASE

#if defined HAVE_FXSCENEOBJECT2D
#include "T2D/fxSceneObject2D.h"
#endif // defined HAVE_FXSCENEOBJECT2D

#include <ode/ode.h>



struct tdBodyData : public GameBaseData {
	typedef GameBaseData Parent;

public:
   DECLARE_CONOBJECT(tdBodyData);
   tdBodyData();
   ~tdBodyData();

   static void consoleInit();
   static void initPersistFields();
   bool preload(bool server, char errorBuffer[256]);
   virtual void packData(BitStream* stream);
   virtual void unpackData(BitStream* stream);
};


class tdBody : public GameBase
{
	typedef GameBase Parent;

private:
	tdBodyData* mDataBlock;
   
public:
	tdBody();
	~tdBody();

	bool onAdd();
	void onRemove();
	static void initPersistFields();
	static void consoleInit();
	bool onNewDataBlock(GameBaseData* dptr);
	void processTick(const Move *move);
	void interpolateTick(F32 delta);
	void advanceTime(F32 dt);

	U32  packUpdate  (NetConnection *conn, U32 mask, BitStream *stream);
	void unpackUpdate(NetConnection *conn, BitStream *stream);
   
	DECLARE_CONOBJECT(tdBody);

	dBodyID body;
	int iscreated; // Set after the body gets created

	enum UpdateMaskBits {
		NewWorld = Parent::NextFreeMask << 0,
		NewShape = Parent::NextFreeMask << 1,
		NewPosition = Parent::NextFreeMask << 2
	};

	S32 worldsim;
	S32 mass;
	void damp(float factor);
	void SetTransform(const char *line);

#if defined HAVE_SHAPEBASE
	// For updating entire shapes
	S32 shapeid;
	void UpdateShape();
	void UpdateFromShape();
	
	// If updating just a bone is your thing
	TSShapeInstance* mShapeInstance; // If you're updating individual nodes, this is the shape they're in
	S32 nodeid;
	void UpdateNode();
	void UpdateFromNode();
#endif // defined HAVE_SHAPEBASE
#if defined HAVE_FXSCENEOBJECT2D
	S32 sceneobjectid;
	void UpdateSceneObject();
#endif // defined HAVE_FXSCENEOBJECT2D
};


#endif // __TBODY_H
