#ifndef __TMASS_H
#define __TMASS_H

#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "game/gameBase.h"
#include <ode/ode.h>

struct tdMassData : public GameBaseData {
	typedef GameBaseData Parent;

public:
	DECLARE_CONOBJECT(tdMassData);
	tdMassData();
	~tdMassData();

	static void consoleInit();
	static void initPersistFields();
	bool preload(bool server, char errorBuffer[256]);
	virtual void packData(BitStream* stream);
	virtual void unpackData(BitStream* stream);
};


class tdMass : public GameBase
{
	typedef GameBase Parent;

private:
	tdMassData* mDataBlock;
   
public:
	tdMass();
	~tdMass();

	bool onAdd();
	void onRemove();
	static void initPersistFields();
	static void consoleInit();
	bool onNewDataBlock(GameBaseData* dptr);
	void processTick(const Move *move);
	void interpolateTick(F32 delta);
	void advanceTime(F32 dt);

	U32  packUpdate  (NetConnection *conn, U32 mask, BitStream *stream);
	void unpackUpdate(NetConnection *conn, BitStream *stream);
   
	DECLARE_CONOBJECT(tdMass);
	
	enum UpdateMaskBits {
		NewMass = Parent::NextFreeMask << 0
	};

	dMass mass;
};

#endif // __TMASS_H
