#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "game/gameBase.h"
#include "core/bitStream.h"
#include <ode/ode.h>
#include "tmass.h"
#include "odehelper.h"



IMPLEMENT_CO_DATABLOCK_V1(tdMassData);

tdMassData::tdMassData()
{
}

tdMassData::~tdMassData()
{
}


void tdMassData::consoleInit()
{
	Parent::consoleInit();
}

void tdMassData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdMassData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdMassData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdMassData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdMass);


tdMass::tdMass() {
	// mNetFlags.set(ScopeAlways | Ghostable);
	mNetFlags.clear(Ghostable);
}

tdMass::~tdMass() {
}

bool tdMass::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	return true;
}

void tdMass::onRemove() {
	Parent::onRemove();
}

void tdMass::consoleInit()
{
	Parent::consoleInit();
}

bool tdMass::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdMassData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdMass::processTick(const Move* move)
{
	Parent::processTick(move);
}

void tdMass::initPersistFields()
{
	Parent::initPersistFields();
}

void tdMass::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdMass::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

// Next line ripped from ode's mass.cpp
#define _I(i,j) I[(i)*4+(j)]

U32 tdMass::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	U32 ret = Parent::packUpdate(conn, mask, stream);
	if(stream->writeFlag(mask&NewMass)) {
		stream->writeFloat(mass.mass,32);
		stream->writeFloat(mass.c[0],32);
		stream->writeFloat(mass.c[1],32);
		stream->writeFloat(mass.c[2],32);
		stream->writeFloat(mass.c[3],32);
		stream->writeFloat(mass._I(0,0),32);
		stream->writeFloat(mass._I(0,1),32);
		stream->writeFloat(mass._I(0,2),32);
		stream->writeFloat(mass._I(1,0),32);
		stream->writeFloat(mass._I(1,1),32);
		stream->writeFloat(mass._I(1,2),32);
		stream->writeFloat(mass._I(2,0),32);
		stream->writeFloat(mass._I(2,1),32);
		stream->writeFloat(mass._I(2,2),32);
	}
	return ret;
}

void tdMass::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
	if(stream->readFlag()) {
		mass.mass = stream->readFloat(32);
		mass.c[0] = stream->readFloat(32);
		mass.c[1] = stream->readFloat(32);
		mass.c[2] = stream->readFloat(32);
		mass.c[3] = stream->readFloat(32);
		mass._I(0,0) = stream->readFloat(32);
		mass._I(0,1) = stream->readFloat(32);
		mass._I(0,2) = stream->readFloat(32);
		mass._I(1,0) = stream->readFloat(32);
		mass._I(1,1) = stream->readFloat(32);
		mass._I(1,2) = stream->readFloat(32);
		mass._I(2,0) = stream->readFloat(32);
		mass._I(2,1) = stream->readFloat(32);
		mass._I(2,2) = stream->readFloat(32);
	}
}
