#ifndef __TCONTACT_H
#define __TCONTACT_H

#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"
#include <ode/ode.h>


struct tdContactData : public GameBaseData {
	typedef GameBaseData Parent;

public:
	DECLARE_CONOBJECT(tdContactData);
	tdContactData();
	~tdContactData();

	static void consoleInit();
	static void initPersistFields();
	bool preload(bool server, char errorBuffer[256]);
	virtual void packData(BitStream* stream);
	virtual void unpackData(BitStream* stream);
};


class tdContact : public GameBase
{
	typedef GameBase Parent;

private:
	tdContactData* mDataBlock;
   
public:
	tdContact();
	~tdContact();

	bool onAdd();
	void onRemove();
	static void initPersistFields();
	static void consoleInit();
	bool onNewDataBlock(GameBaseData* dptr);
	void processTick(const Move *move);
	void interpolateTick(F32 delta);
	void advanceTime(F32 dt);

	U32  packUpdate  (NetConnection *conn, U32 mask, BitStream *stream);
	void unpackUpdate(NetConnection *conn, BitStream *stream);
   
	DECLARE_CONOBJECT(tdContact);

	dContact contact;
};

#endif // __TCONTACT_H
