#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "math/mMathFn.h"
#include "odehelper.h"

int ODEOneOrThree(int argc, const char **argv, float *x, float *y, float *z) {

	int error = 1;

	if(5 == argc) {
		*x = dAtof(argv[2]);
		*y = dAtof(argv[3]);
		*z = dAtof(argv[4]);
		error = 0;
	} else if (3 == argc) {
		if(3 == dSscanf(argv[2], "%f %f %f", x, y, z)) {
			error = 0;
		}
	}

	return error;
}

int ODEOneOrFour(int argc, const char **argv, float *w,
	float *x, float *y, float *z) {

	int error = 1;

	if(6 == argc) {
		*x = dAtof(argv[2]);
		*y = dAtof(argv[3]);
		*z = dAtof(argv[4]);
		*w = dAtof(argv[5]);
		error = 0;
	} else if (3 == argc) {
		if(3 == dSscanf(argv[2], "%f %f %f %f", x, y, z, w)) {
			error = 0;
		}
	}

	return error;
}


int ODETwoOrSix(int argc, const char **argv, float *fx, float *fy, float *fz,
	float *px, float *py, float *pz) {

	int error = 1;

	if(8 == argc) {
		*fx = dAtof(argv[2]);
		*fy = dAtof(argv[3]);
		*fz = dAtof(argv[4]);
		*px = dAtof(argv[5]);
		*py = dAtof(argv[6]);
		*pz = dAtof(argv[7]);
		error = 0;
	} else if (4 == argc) {
		if(3 == dSscanf(argv[2], "%f %f %f", fx, fy, fz) &&
			3 == dSscanf(argv[3], "%f %f %f", px, py, pz)) {
			error = 0;
		}
	}

	return error;
}
