#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "game/gameBase.h"
#include "sim/netConnection.h"
#include "core/bitStream.h"
#include <ode/ode.h>
#include "tjoint.h"
#include "tcontact.h"
#include "tworld.h"
#include "tbody.h"
#include "odehelper.h"




IMPLEMENT_CO_DATABLOCK_V1(tdJointGroupData);

tdJointGroupData::tdJointGroupData()
{
}

tdJointGroupData::~tdJointGroupData()
{
}


void tdJointGroupData::consoleInit()
{
	Parent::consoleInit();
}

void tdJointGroupData::initPersistFields()
{
	Parent::initPersistFields();

}

bool tdJointGroupData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdJointGroupData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdJointGroupData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdJointGroup);


tdJointGroup::tdJointGroup() {
	group = 0;
}

tdJointGroup::~tdJointGroup() {
}

bool tdJointGroup::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	group = dJointGroupCreate(0);
	return true;
}

void tdJointGroup::onRemove() {
	Parent::onRemove();
	dJointGroupDestroy(group);
}

void tdJointGroup::consoleInit()
{
	Parent::consoleInit();
}

bool tdJointGroup::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdJointGroupData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdJointGroup::initPersistFields()
{
	Parent::initPersistFields();

}

void tdJointGroup::processTick(const Move* move)
{
	Parent::processTick(move);
}

void tdJointGroup::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdJointGroup::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdJointGroup::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	return Parent::packUpdate(conn, mask, stream);
}

void tdJointGroup::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
}







IMPLEMENT_CO_DATABLOCK_V1(tdJointData);

tdJointData::tdJointData()
{
}

tdJointData::~tdJointData()
{
}


void tdJointData::consoleInit()
{
	Parent::consoleInit();
}

void tdJointData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdJointData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdJointData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdJointData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdJoint);


tdJoint::tdJoint() {
	mNetFlags.set(ScopeAlways | Ghostable);
	joint = 0;
	body1 = body2 = -1;
	have_type = have_body1 = have_body2 = have_angaxis = 0;
	attached = 0;
}

tdJoint::~tdJoint() {
}

bool tdJoint::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	if(isGhost()) { Con::printf("joint on client, id=%i",getId());}

	updateticks = 0;
	return true;
}

void tdJoint::onRemove() {
	Parent::onRemove();
	// if(joint != 0) {
	//	dJointDestroy(joint);
	// }
}

void tdJoint::consoleInit()
{
	Parent::consoleInit();
}

bool tdJoint::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdJointData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdJoint::processTick(const Move* move)
{
	Parent::processTick(move);
	updateticks++;
	updateticks%=TickMs*3; // Every few seconds
	if(0 == updateticks) {
		setMaskBits(newbodies);
	}

	/* This is mostly due to the potential that torque can ghost bodies after it ghosts the joint
	  When the joint is first ghosted, if it beat the bodies across the connection,
	  then it's impossible to work out which bodies it will eventually be attached to.
	  The body ids get re-copied across the network once every few seconds,
	  and tdJoint attaches them once it feels it has enough information
	*/
	if(isGhost()) {
		// Con::printf("type: %i, body1: %i, body2: %i, angaxis: %i", have_type, have_body1, have_body2, have_angaxis);
	}
	if(have_type && have_body1 && have_body2 && have_angaxis && !attached && isGhost()) {
		Con::printf("Have everything we need on ghost; attaching joint");
		if(body1 != body2) {
			dBodyID b1, b2;
		
			b1 = (0!=body1)?((tdBody *)Sim::findObject(body1))->body:0;
			b2 = (0!=body2)?((tdBody *)Sim::findObject(body2))->body:0;

			dJointAttach(joint,b1,b2);
			attached = 1;
		}
	}
}

void tdJoint::initPersistFields()
{
	Parent::initPersistFields();
	
	addField("body1", TypeS32,
		Offset(body1, tdJoint), "body1. Do not write to this");
	addField("body2", TypeS32,
		Offset(body2, tdJoint), "body2. Do not write to this");

}

void tdJoint::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdJoint::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdJoint::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	U32 ret = Parent::packUpdate(conn, mask, stream);
	
	if(stream->writeFlag(mask&newbodies)) {
		if(0 == body1) {
			stream->writeInt(0,32);
		} else if(-1 != body1) {
			S32 cid = conn->getGhostIndex(Sim::findObject(body1));
			stream->writeInt(cid,32);
		} else {
			stream->writeInt(-1,32);
		}
		
		if(0 == body2) {
			stream->writeInt(0,32);
		} else if(-1 != body2) {
			S32 cid = conn->getGhostIndex(Sim::findObject(body2));
			stream->writeInt(cid,32);
		} else {
			stream->writeInt(-1,32);
		}
	}
	
	if(stream->writeFlag(mask&newtype)) {
		Con::printf("Writing newtype %i", dJointGetType(joint));
		if(0 != joint) {
			stream->writeInt(dJointGetType(joint),32);
		} else {
			stream->writeInt(-1,32);
		}
	}
	
	if(stream->writeFlag(mask&newangaxis)) {
		dVector3 result;
		switch(dJointGetType(joint)) {
			case dJointTypeBall:
				dJointGetBallAnchor(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				break;
			case dJointTypeHinge:
				dJointGetHingeAxis(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				dJointGetHingeAnchor(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				break;
			case dJointTypeSlider:
				dJointGetSliderAxis(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);				
				break;
			case dJointTypeUniversal:
				dJointGetUniversalAnchor(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				dJointGetUniversalAxis1(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				dJointGetUniversalAxis2(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				break;
			case dJointTypeHinge2:
				dJointGetHinge2Anchor(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				dJointGetHinge2Axis1(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				dJointGetHinge2Axis2(joint, result);
				stream->writeFloat(result[0],32);
				stream->writeFloat(result[1],32);
				stream->writeFloat(result[2],32);
				break;
			case dJointTypeFixed:
				// Nothing. Fixed joints don't have axis/angle stuff
				break;
			case dJointTypeAMotor:
				break;
			case dJointTypeContact:
			default:
				// Nothing. Ignore contact joints.
				break;
		}
	}
	return ret;
}

void tdJoint::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
	S32 i;
	NetObject *t;
	if(stream->readFlag()) {
		// Body1
		i = stream->readInt(32);
		if(0 == i) {
			body1 = 0;
		} else {
			t = conn->resolveGhost(i);
			if(NULL != t) body1 = t->getId();
		}
		
		// Body2
		i = stream->readInt(32);
		if(0 == i) {
			body2 = 0;
		} else {
			t = conn->resolveGhost(i);
			if(NULL != t) body2 = t->getId();
		}
		
		if(-1 != body1) have_body1=1;
		if(-1 != body2) have_body2=1;
	}
	
	// New type of joint created
	if(stream->readFlag()) {
		tdWorld *wtmp = (tdWorld *)Sim::findObject(Con::getIntVariable("$odeworldclient"));
		U32 jointtype = stream->readInt(32);
		switch(jointtype) {
			case dJointTypeBall:
				joint = dJointCreateBall(wtmp->world,0);
				have_type=1;
				break;
			case dJointTypeHinge:
				joint = dJointCreateHinge(wtmp->world,0);
				have_type=1;
				break;
			case dJointTypeSlider:
				joint = dJointCreateSlider(wtmp->world,0);
				have_type=1;
				break;
			case dJointTypeUniversal:
				joint = dJointCreateUniversal(wtmp->world,0);
				have_type=1;
				break;
			case dJointTypeHinge2:
				joint = dJointCreateHinge2(wtmp->world,0);
				have_type=1;
				break;
			case dJointTypeFixed:
				joint = dJointCreateFixed(wtmp->world,0);
				have_type=1;
				break;
			case dJointTypeAMotor:
				joint = dJointCreateAMotor(wtmp->world,0);
				have_type=1;
				break;
			case dJointTypeContact:
			default:
				// Nothing. Ignore contact joints.
				break;
		}
	}
	
	// Parameters
	if(stream->readFlag()) {
		dVector3 result;
		switch(dJointGetType(joint)) {
			case dJointTypeBall:
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetBallAnchor(joint, result[0], result[1], result[2]);
				break;
			case dJointTypeHinge:
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetHingeAxis(joint, result[0], result[1], result[2]);
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetHingeAnchor(joint, result[0], result[1], result[2]);
				break;
			case dJointTypeSlider:
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetSliderAxis(joint, result[0], result[1], result[2]);
				break;
			case dJointTypeUniversal:
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetUniversalAnchor(joint, result[0], result[1], result[2]);
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetUniversalAxis1(joint, result[0], result[1], result[2]);
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetUniversalAxis2(joint, result[0], result[1], result[2]);
				break;
			case dJointTypeHinge2:
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetHinge2Anchor(joint, result[0], result[1], result[2]);
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetHinge2Axis1(joint, result[0], result[1], result[2]);
				result[0] = stream->readFloat(32);
				result[1] = stream->readFloat(32);
				result[2] = stream->readFloat(32);
				dJointSetHinge2Axis2(joint, result[0], result[1], result[2]);
				break;
			case dJointTypeFixed:
				// Nothing. fixed joints don't have axisanglesstuff
				break;
			case dJointTypeAMotor:
				break;
			case dJointTypeContact:
			default:
				// Nothing. Ignore contact joints.
				break;
		}
		have_angaxis=1;
	}
}

