#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"

#if defined HAVE_SHAPEBASE
#include "game/shapeBase.h"
#endif // defined HAVE_SHAPEBASE

#if defined HAVE_FXSCENEOBJECT2D
#include "T2D/fxSceneObject2D.h"
#endif // defined HAVE_FXSCENEOBJECT2D

#include "math/mMathFn.h"
#include "math/mQuat.h"
#include <ode/ode.h>
#include "tbody.h"
#include "tworld.h"
#include "tmass.h"
#include "tcontact.h"
#include "odehelper.h"


ConsoleMethod(tdContact, SetPos, void, 3, 5,
	"(x,y,z) or (\"x y z\") "
	"equivalent of ode dContactGeom.pos") {

	argc; argv;
	float x,y,z;
	if(0 != ODEOneOrThree(argc,argv,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		object->contact.geom.pos[0] = x;
		object->contact.geom.pos[1] = y;
		object->contact.geom.pos[2] = z;
	}
}

ConsoleMethod(tdContact, SetNormal, void, 3, 5,
	"(x,y,z) or (\"x y z\") "
	"equivalent of ode dContactGeom.normal") {

	argc; argv;
	float x,y,z;
	if(0 != ODEOneOrThree(argc,argv,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		object->contact.geom.normal[0] = x;
		object->contact.geom.normal[1] = y;
		object->contact.geom.normal[2] = z;
	}
}

ConsoleMethod(tdContact, SetFdir1, void, 3, 5,
	"(x,y,z) or (\"x y z\") "
	"equivalent of ode dContact.fdir1") {

	argc; argv;
	float x,y,z;
	if(0 != ODEOneOrThree(argc,argv,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		object->contact.fdir1[0] = x;
		object->contact.fdir1[1] = y;
		object->contact.fdir1[2] = z;
	}
}

ConsoleMethod(tdContact, SetSurfaceMode, void, 4, 4,
	"(flag, yes) "
	"equivalent to setting a flag on dSurfaceParameters.mode") {

	argc; argv;
	const char *flag = argv[2];
	int yes = dAtoi(argv[3]);

	if(0 == dStricmp(flag, "dContactMu2")) {
		if(yes) object->contact.surface.mode |= dContactMu2;
		else object->contact.surface.mode &= !dContactMu2;
	} else if(0 == dStricmp(flag, "dContactFDir1")) {
		if(yes) object->contact.surface.mode |= dContactFDir1;
		else object->contact.surface.mode &= !dContactFDir1;
	} else if(0 == dStricmp(flag, "dContactBounce")) {
		if(yes) object->contact.surface.mode |= dContactBounce;
		else object->contact.surface.mode &= !dContactBounce;
	} else if(0 == dStricmp(flag, "dContactSoftERP")) {
		if(yes) object->contact.surface.mode |= dContactSoftERP;
		else object->contact.surface.mode &= !dContactSoftERP;
	} else if(0 == dStricmp(flag, "dContactSoftCFM")) {
		if(yes) object->contact.surface.mode |= dContactSoftCFM;
		else object->contact.surface.mode &= !dContactSoftCFM;
	} else if(0 == dStricmp(flag, "dContactMotion1")) {
		if(yes) object->contact.surface.mode |= dContactMotion1;
		else object->contact.surface.mode &= !dContactMotion1;
	} else if(0 == dStricmp(flag, "dContactMotion2")) {
		if(yes) object->contact.surface.mode |= dContactMotion2;
		else object->contact.surface.mode &= !dContactMotion2;
	} else if(0 == dStricmp(flag, "dContactSlip1")) {
		if(yes) object->contact.surface.mode |= dContactSlip1;
		else object->contact.surface.mode &= !dContactSlip1;
	} else if(0 == dStricmp(flag, "dContactSlip2")) {
		if(yes) object->contact.surface.mode |= dContactSlip2;
		else object->contact.surface.mode &= !dContactSlip2;
	} else if(0 == dStricmp(flag, "dContactApprox1_1")) {
		if(yes) object->contact.surface.mode |= dContactApprox1_1;
		else object->contact.surface.mode &= !dContactApprox1_1;
	} else if(0 == dStricmp(flag, "dContactApprox1_2")) {
		if(yes) object->contact.surface.mode |= dContactApprox1_2;
		else object->contact.surface.mode &= !dContactApprox1_2;
	} else if(0 == dStricmp(flag, "dContactApprox1")) {
		if(yes) object->contact.surface.mode |= dContactApprox1;
		else object->contact.surface.mode &= !dContactApprox1;
	}
}
