#ifndef __TJOINT_H
#define __TJOINT_H

#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "game/gameBase.h"
#include <ode/ode.h>



struct tdJointGroupData : public GameBaseData {
	typedef GameBaseData Parent;

public:
   DECLARE_CONOBJECT(tdJointGroupData);
   tdJointGroupData();
   ~tdJointGroupData();

   static void consoleInit();
   static void initPersistFields();
   bool preload(bool server, char errorBuffer[256]);
   virtual void packData(BitStream* stream);
   virtual void unpackData(BitStream* stream);
};


class tdJointGroup : public GameBase
{
	typedef GameBase Parent;

private:
	tdJointGroupData* mDataBlock;
   
public:
	tdJointGroup();
	~tdJointGroup();

	bool onAdd();
	void onRemove();
	static void initPersistFields();
	static void consoleInit();
	bool onNewDataBlock(GameBaseData* dptr);
	void processTick(const Move *move);
	void interpolateTick(F32 delta);
	void advanceTime(F32 dt);

	U32  packUpdate  (NetConnection *conn, U32 mask, BitStream *stream);
	void unpackUpdate(NetConnection *conn, BitStream *stream);
   
	DECLARE_CONOBJECT(tdJointGroup);

	dJointGroupID group;

};


struct tdJointData : public GameBaseData {
	typedef GameBaseData Parent;

public:
	DECLARE_CONOBJECT(tdJointData);
	tdJointData();
	~tdJointData();

	static void consoleInit();
	static void initPersistFields();
	bool preload(bool server, char errorBuffer[256]);
	virtual void packData(BitStream* stream);
	virtual void unpackData(BitStream* stream);
};


class tdJoint : public GameBase
{
	typedef GameBase Parent;

private:
	tdJointData* mDataBlock;
   
public:
	tdJoint();
	~tdJoint();

	bool onAdd();
	void onRemove();
	static void initPersistFields();
	static void consoleInit();
	bool onNewDataBlock(GameBaseData* dptr);
	void processTick(const Move *move);
	void interpolateTick(F32 delta);
	void advanceTime(F32 dt);

	U32  packUpdate  (NetConnection *conn, U32 mask, BitStream *stream);
	void unpackUpdate(NetConnection *conn, BitStream *stream);
   
	DECLARE_CONOBJECT(tdJoint);
	

	dJointID joint;
	S32 body1, body2;
   
};


#endif // __TJOINT_H
