#ifndef _ODESHAPE_H_
#define _ODESHAPE_H_

#include "torque_ver.h"
#include "game/shapeBase.h"
#include "collision/boxConvex.h"

#if defined HAVE_SHAPEBASE
//----------------------------------------------------------------------------
struct ODEShapeData: public ShapeBaseData {
   typedef ShapeBaseData Parent;

public:
   DECLARE_CONOBJECT(ODEShapeData);
   ODEShapeData();
   ~ODEShapeData();
   static void consoleInit();
   static void initPersistFields();
   bool preload(bool server, char errorBuffer[256]);
   virtual void packData(BitStream* stream);
   virtual void unpackData(BitStream* stream);
};

//----------------------------------------------------------------------------
class ODEShape: public ShapeBase
{
   typedef ShapeBase Parent;

private:
   ODEShapeData* mDataBlock;
   float time;
   Point3F vel;

protected:
   enum MaskBits {
      PositionMask = Parent::NextFreeMask
   };

public:
   ShapeBaseConvex mConvex;
   Box3F          mWorkingQueryBox;
   VectorF mVelocity; 

   DECLARE_CONOBJECT(ODEShape);
   ODEShape();
   ~ODEShape();

   bool onAdd();
   void onRemove();
   static void initPersistFields();
   static void consoleInit();
   bool onNewDataBlock(GameBaseData* dptr);
   void processTick(const Move *move);
   void interpolateTick(F32 delta);
   void advanceTime(F32 dt);

   void setVelocity(const VectorF& v);
   void updateWorkingCollisionSet();

   U32  packUpdate(NetConnection *conn, U32 mask, BitStream *stream);
   void unpackUpdate(NetConnection *conn, BitStream *stream);
   
   // This is the contact joint group that contact joints will automatically be put into
	S32 contactgroup;
	S32 worldsim;
	S32 odeobj;
	bool disablecollisions;
};

#endif // defined HAVE_SHAPEBASE

#endif // _ODESHAPE_H_
