#ifndef __TWORLD_H
#define __TWORLD_H

#include "torque_ver.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"
#include <ode/ode.h>

struct tdWorldData : public GameBaseData {
	typedef GameBaseData Parent;

public:
	DECLARE_CONOBJECT(tdWorldData);
	tdWorldData();
	~tdWorldData();

	static void consoleInit();
	static void initPersistFields();
	bool preload(bool server, char errorBuffer[256]);
	virtual void packData(BitStream* stream);
	virtual void unpackData(BitStream* stream);
};


class tdWorld : public GameBase
{
	typedef GameBase Parent;

private:
	tdWorldData* mDataBlock;
   
public:
	tdWorld();
	~tdWorld();

	bool onAdd();
	void onRemove();
	static void initPersistFields();
	static void consoleInit();
	bool onNewDataBlock(GameBaseData* dptr);
	void processTick(const Move *move);
	void interpolateTick(F32 delta);
	void advanceTime(F32 dt);

	U32  packUpdate  (NetConnection *conn, U32 mask, BitStream *stream);
	void unpackUpdate(NetConnection *conn, BitStream *stream);
   
	DECLARE_CONOBJECT(tdWorld);

	dWorldID world;
	int istorqueworld;
	S32 contactjointgroup;


};

#endif // __TWORLD_H
