#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "game/gameBase.h"
#include <ode/ode.h>
#include "tmass.h"
#include "odehelper.h"



IMPLEMENT_CO_DATABLOCK_V1(tdMassData);

tdMassData::tdMassData()
{
}

tdMassData::~tdMassData()
{
}


void tdMassData::consoleInit()
{
	Parent::consoleInit();
}

void tdMassData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdMassData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdMassData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdMassData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdMass);


tdMass::tdMass() {
	mNetFlags.set(ScopeAlways | Ghostable);
}

tdMass::~tdMass() {
}

bool tdMass::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	return true;
}

void tdMass::onRemove() {
	Parent::onRemove();
}

void tdMass::consoleInit()
{
	Parent::consoleInit();
}

bool tdMass::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdMassData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdMass::processTick(const Move* move)
{
	Parent::processTick(move);
}

void tdMass::initPersistFields()
{
	Parent::initPersistFields();
}

void tdMass::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdMass::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdMass::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	return Parent::packUpdate(conn, mask, stream);
}

void tdMass::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
}
