#ifndef __TBODY_H
#define __TBODY_H

#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"

#if defined HAVE_SHAPEBASE
#include "game/shapeBase.h"
#endif // defined HAVE_SHAPEBASE

#if defined HAVE_FXSCENEOBJECT2D
#include "T2D/fxSceneObject2D.h"
#endif // defined HAVE_FXSCENEOBJECT2D

#include <ode/ode.h>



struct tdBodyData : public GameBaseData {
	typedef GameBaseData Parent;

public:
   DECLARE_CONOBJECT(tdBodyData);
   tdBodyData();
   ~tdBodyData();

   static void consoleInit();
   static void initPersistFields();
   bool preload(bool server, char errorBuffer[256]);
   virtual void packData(BitStream* stream);
   virtual void unpackData(BitStream* stream);
};


class tdBody : public GameBase
{
	typedef GameBase Parent;

private:
	tdBodyData* mDataBlock;
   
public:
	tdBody();
	~tdBody();

	bool onAdd();
	void onRemove();
	static void initPersistFields();
	static void consoleInit();
	bool onNewDataBlock(GameBaseData* dptr);
	void processTick(const Move *move);
	void interpolateTick(F32 delta);
	void advanceTime(F32 dt);

	U32  packUpdate  (NetConnection *conn, U32 mask, BitStream *stream);
	void unpackUpdate(NetConnection *conn, BitStream *stream);
   
	DECLARE_CONOBJECT(tdBody);

	dBodyID body;
	int iscreated; // Set after the body gets created
	
	S32 worldsim;
	S32 mass;
	void damp(float factor);
#if defined HAVE_SHAPEBASE
	S32 shapeid;
	void UpdateShape();
	void UpdateFromShape();
	void SetTransform(const char *line);
#endif // defined HAVE_SHAPEBASE
#if defined HAVE_FXSCENEOBJECT2D
	S32 sceneobjectid;
	void UpdateSceneObject();
#endif // defined HAVE_FXSCENEOBJECT2D
};


#endif // __TBODY_H
