#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "game/gameBase.h"
#include <ode/ode.h>
#include "tjoint.h"
#include "tcontact.h"
#include "tworld.h"
#include "tbody.h"
#include "odehelper.h"




IMPLEMENT_CO_DATABLOCK_V1(tdJointGroupData);

tdJointGroupData::tdJointGroupData()
{
}

tdJointGroupData::~tdJointGroupData()
{
}


void tdJointGroupData::consoleInit()
{
	Parent::consoleInit();
}

void tdJointGroupData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdJointGroupData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdJointGroupData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdJointGroupData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdJointGroup);


tdJointGroup::tdJointGroup() {
}

tdJointGroup::~tdJointGroup() {
}

bool tdJointGroup::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	group = dJointGroupCreate(0);
	return true;
}

void tdJointGroup::onRemove() {
	Parent::onRemove();
	dJointGroupDestroy(group);
}

void tdJointGroup::consoleInit()
{
	Parent::consoleInit();
}

bool tdJointGroup::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdJointGroupData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdJointGroup::initPersistFields()
{
	Parent::initPersistFields();

}

void tdJointGroup::processTick(const Move* move)
{
	Parent::processTick(move);
}

void tdJointGroup::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdJointGroup::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdJointGroup::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	return Parent::packUpdate(conn, mask, stream);
}

void tdJointGroup::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
}







IMPLEMENT_CO_DATABLOCK_V1(tdJointData);

tdJointData::tdJointData()
{
}

tdJointData::~tdJointData()
{
}


void tdJointData::consoleInit()
{
	Parent::consoleInit();
}

void tdJointData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdJointData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdJointData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdJointData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdJoint);


tdJoint::tdJoint() {
	joint = 0;
}

tdJoint::~tdJoint() {
}

bool tdJoint::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	return true;
}

void tdJoint::onRemove() {
	Parent::onRemove();
	// if(joint != 0) {
	//	dJointDestroy(joint);
	// }
}

void tdJoint::consoleInit()
{
	Parent::consoleInit();
}

bool tdJoint::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdJointData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdJoint::processTick(const Move* move)
{
	Parent::processTick(move);
}

void tdJoint::initPersistFields()
{
	Parent::initPersistFields();
}

void tdJoint::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdJoint::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdJoint::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	return Parent::packUpdate(conn, mask, stream);
}

void tdJoint::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
}

