// This is what you need for an ODEShape to do what it does:

// These two are normally in ~/shapes/data/boulder/boulder.cs
//  And there's a .dts in that dir called "boulder.dts"
// Check the rigid shape resource

datablock ODEShapeData(ODEBoulderData)
{
	shapeFile = "./boulder.dts";
	category = "Boulders";
	emap = true;
};

function ODEShapeData::create(%data)
{
	// The mission editor invokes this method when it wants to create
	// an object of the given datablock type.
	// Good thing torque doesn't garbage collect, because this
	// is sort of a recursive data structure. Or, uh, something.
	// *ahem*

	%obj = new ODEShape() {
		dataBlock = %data;
	};

	%odemass = new tdMass() {
		datablock = odemassdata;
	};
	%odemass.SetSphereTotal(5, 10);
	%odeobj = new tdBody() {
		datablock = odebodydata;
		worldsim = $odeworld;
		shapeid = %obj;
	};
	%odeobj.SetMass(%odemass);
	%obj.odeobj = %odeobj;

	return %obj;
}


// This is somewhere in ~/server/

function ODEShapeData::onCollision(%this, %obj, %col, %vec, %len) {
	// %this is the BoulderShapeData
	// %obj is the BoulderShape
	// %col is the Other thing [eg, player]
	// %vec is the Normal Vector
	// %len should be the depth of penetration

	echo("This:" SPC %this);
	echo("Obj:" SPC %obj);
	echo("Col:" SPC %col);
	echo("Vec:" SPC %vec);
	echo("Len:" SPC %len);
	echo("");

	if(0 == %obj.odeobj && 0 == %col.odeobj) {
		return;
	}

	// From here down isn't necessary if AutoContact is set.
	// Please see defaults.cs
	
	// %c = new tdContact() { datablock = odecontactdata; };
	// %c.SetNormal(%vec);
	// %c.Depth = %len;
	// %c.SetSurfaceMode("dContactSoftERP",1);
	// %c.SetSurfaceMode("dContactSoftCFM",1);

	// %j = new tdJoint() { datablock = odejointdata; };
	// %j.CreateContact($odeworld, $odecollisionjg, %c);

	// If there's no odeobj on one of the objects, this will
	// magically do the right thing, which is evaluate to zero,
	// and create a joint with the world.
	// %j.Attach(%obj.odeobj, %col.odeobj);
}
