#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include "game/gameBase.h"

#if defined HAVE_SHAPEBASE
#include "game/shapeBase.h"
#endif // defined HAVE_SHAPEBASE

#if defined HAVE_FXSCENEOBJECT2D
#include "T2D/fxSceneObject2D.h"
#endif // defined HAVE_FXSCENEOBJECT2D

#include "math/mMathFn.h"
#include "math/mQuat.h"
#include <ode/ode.h>
#include "tbody.h"
#include "tworld.h"
#include "tmass.h"
#include "odehelper.h"



IMPLEMENT_CO_DATABLOCK_V1(tdBodyData);

tdBodyData::tdBodyData()
{
}

tdBodyData::~tdBodyData()
{
}


void tdBodyData::consoleInit()
{
	Parent::consoleInit();
}

void tdBodyData::initPersistFields()
{
	Parent::initPersistFields();
}

bool tdBodyData::preload(bool server, char errorBuffer[256])
{
	return Parent::preload(server, errorBuffer);
}

void tdBodyData::packData(BitStream* stream)
{
	Parent::packData(stream);
}

void tdBodyData::unpackData(BitStream* stream)
{
	Parent::unpackData(stream);
}


IMPLEMENT_CO_NETOBJECT_V1(tdBody);


tdBody::tdBody() {
	worldsim = 0;
	body = 0;
	iscreated = 0;
#if defined HAVE_SHAPEBASE
	shapeid = 0;
#endif // defined HAVE_SHAPEBASE

#if defined HAVE_FXSCENEOBJECT2D
	sceneobjectid = 0;
#endif // defined HAVE_FXSCENEOBJECT2D
}

tdBody::~tdBody() {
}

bool tdBody::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	
	tdWorld *w;
	w = (tdWorld *)Sim::findObject(worldsim);

	if(NULL == w) {
		iscreated = 0;
	} else {
		body = dBodyCreate(w->world);
		iscreated = 1;
	}
	return true;
}

void tdBody::onRemove() {
	Parent::onRemove();
	if(iscreated) {
		dBodyDestroy(body);
		iscreated = 0;
	}
}

void tdBody::consoleInit()
{
	Parent::consoleInit();
}

bool tdBody::onNewDataBlock(GameBaseData* dptr)
{
	mDataBlock = dynamic_cast<tdBodyData*>(dptr);
	if (!mDataBlock || !Parent::onNewDataBlock(dptr))
		return false;

   scriptOnNewDataBlock();
   return true;
}

void tdBody::initPersistFields()
{
	Parent::initPersistFields();
	
	addField("worldsim", TypeS32,
		Offset(worldsim, tdBody), "The tdWorld the body is in");
#if defined HAVE_SHAPEBASE
	addField("shapeid", TypeS32,
		Offset(shapeid, tdBody), "The ShapeBase-derived object the body represents");
#endif // defined SHAPEBASE
#if defined HAVE_FXSCENEOBJECT2D
	addField("sceneobjectid", TypeS32,
		Offset(sceneobjectid, tdBody), "The fxSceneObject2D-derived object the body represents");
#endif // defined HAVE_FXSCENEOBJECT2D

}

void tdBody::processTick(const Move* move)
{
	Parent::processTick(move);
#if defined HAVE_SHAPEBASE
	UpdateShape();
#endif // defined HAVE_SHAPEBASE

#if defined HAVE_FXSCENEOBJECT2D
	UpdateSceneObject();
#endif // defined HAVE_FXSCENEOBJECT2D
}

void tdBody::interpolateTick(F32 delta)
{
	Parent::interpolateTick(delta);
}

void tdBody::advanceTime(F32 dt)
{
	Parent::advanceTime(dt);
}

U32 tdBody::packUpdate(NetConnection *conn, U32 mask, BitStream *stream)
{
	return Parent::packUpdate(conn, mask, stream);
}

void tdBody::unpackUpdate(NetConnection *conn, BitStream *stream)
{
	Parent::unpackUpdate(conn, stream);
}

#if defined HAVE_SHAPEBASE
void tdBody::UpdateShape() {
	const dReal *v, *p, *r; // Velocity, Position & Rotation of ODE body

	ShapeBase *s;
	s = (ShapeBase *)Sim::findObject(shapeid);
	if(NULL == s) return;
	
	v = dBodyGetLinearVel(body);
	s->setVelocity(Point3F(v[0],v[1],v[2]));


	p = dBodyGetPosition(body);
	r = dBodyGetQuaternion(body);

	// Code from here down flagrantly ripped from sceneObject.cc
	
	Point3F pos;
	const MatrixF& tmat = s->getTransform();
	tmat.getColumn(3,&pos);
	
	AngAxisF aa(tmat);

	// Next three lines take the ODE quat and turn into an AngAxisF
	QuatF odeq(r[0], r[1], r[2], r[3]);
	AngAxisF odeaa(odeq);
	Point3F odepoint = odeaa.axis;
	
	pos.x = p[0];
	pos.y = p[1];
	pos.z = p[2];
	aa.axis.x = odeaa.axis.x;
	aa.axis.y = odeaa.axis.y;
	aa.axis.z = odeaa.axis.z;
	aa.angle = odeaa.angle;
	
	MatrixF mat;
	aa.setMatrix(&mat);
	mat.setColumn(3,pos);
	s->setTransform(mat);
}
#endif // defined HAVE_SHAPEBASE


#if defined HAVE_FXSCENEOBJECT2D
void UpdateSceneObject() {

	const dReal *v, *p, *r; // Velocity, Position & Rotation of ODE body

	fxSceneObject2D *s;
	s = (fxSceneObject2D *)Sim::findObject(sceneobjectid);
	if(NULL == s) return;
	
	v = dBodyGetLinearVel(body);
	s->setLinearVelocity(fxVector2D(v[0],v[1]));
	
	v = dBodyGetAngularVel(body);
	s->setAngularVelocity(v[2]);
	
	p = dBodyGetPosition(body);
	s->setPosition(fxVector2D(v[0],v[1]));
	return;
	r = dBodyGetQuaternion(body);
	
	
	// See GetEulerAngles above for more help on this one
	
	const dReal *mat;
	F32 angle_y, angle_x, angle_z;
	F32 trxx, tryy, C, D; // Temp variables

	mat = dBodyGetRotation(body);

	
	angle_y = D =  mAsin( mat[2]);		/* Calculate Y-axis angle */
	C		   =  mCos( angle_y );
	
	if ( fabs( C ) > 0.005 ) {			 /* Gimball lock? */
		trxx	  =  mat[10] / C;		   /* No, so get X-axis angle */
		tryy	  = -mat[6]  / C;
		angle_x  = mAtan( tryy, trxx );
		trxx	  =  mat[0] / C;			/* Get Z-axis angle */
		tryy	  = -mat[1] / C;
		angle_z  = mAtan( tryy, trxx );
	} else {								/* Gimball lock has occurred */
		angle_x  = 0;						 /* Set X-axis angle to zero */
		trxx	  =  mat[5];				 /* And calculate Z-axis angle */
		tryy	  =  mat[4];
		angle_z  = mAtan( tryy, trxx );
	}
	
	if (angle_z < 0) angle_z += 2 * M_PI;
	// Need to subtract 90 in here?
	s->setRotation(mRadToDeg(angle_z));
}
#endif // defined HAVE_FXSCENEOBJECT2D
