#ifndef __ODEHELPER_H
#define __ODEHELPER_H

#include "torque_ver.h"
#include "console/consoleObject.h"

// THESE FUNCTIONS LEAVE
//   w, x, y, z, fx, fy, fz, px, py, pz
//   IN INDETERMINATE STATES IF THEY RETURN NON-ZERO

// For ConsoleFunctions that can take either
// (x,y,z), or
// ("x y z")
int ODEOneOrThree(int argc, const char **argv,
	float *x, float *y, float *z);
	
// For ConsoleFunctions that can take either
// (w,x,y,z), or
// ("w x y z")
int ODEOneOrFour(int argc, const char **argv,
	float *w, float *x, float *y, float *z);

// For ConsoleFunctions that can take either
// (fx,fy,fz,px,py,pz), or
// ("fx fy fz","px py pz")
int ODETwoOrSix(int argc, const char **argv,
	float *fx, float *fy, float *fz,
	float *px, float *py, float *pz);


#endif // __ODEHELPER_H
