#ifndef __TBODY_H
#define __TBODY_H

#include "torque_ver.h"
#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"

#if defined TAP_TGE || defined TAP_TSE
#include "game/shapeBase.h"
#endif // defined TAP_TGE || defined TAP_TSE

#if defined TAP_T2D
#include "T2D/fxSceneObject2D.h"
#endif // defined TAP_T2D

#include <ode/ode.h>

class tdBody:public SimObject {
public:
	typedef SimObject Parent;

	dBodyID body;
	tdBody();
	bool onAdd();
	void onRemove();

	int iscreated;

	DECLARE_CONOBJECT(tdBody);

	S32 worldsim;
	S32 mass;
#if defined TAP_TGE || defined TAP_TSE
	S32 shapeid;
#endif // defined TAP_TGE || defined TAP_TSE
#if defined TAP_T2D
	S32 sceneobjectid;
#endif // defined TAP_T2D


	static void initPersistFields();
};

#endif // __TBODY_H
