#include "console/simBase.h"
#include "console/consoleObject.h"
#include <ode/ode.h>
#include "tworld.h"
#include "odehelper.h"

bool tdWorld::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	world = dWorldCreate();
	istorqueworld = 0;
	return true;
}

void tdWorld::onRemove() {
	if(!istorqueworld) {
		dWorldDestroy(world);
	}
	Parent::onRemove();
}

IMPLEMENT_CONOBJECT(tdWorld);

void tdWorld::initPersistFields()
{
	Parent::initPersistFields();
}


ConsoleMethod(tdWorld, SetWorldToTorque, void, 2, 2,
	"() "
	"Set the world to be the one in use in the rest of Torque") {

	// Make this dWorldDestroy(world);
	// world = torqueworld {whatever that is}
	object->istorqueworld = 1;
}

ConsoleMethod(tdWorld, SetGravity, void, 3, 5,
	"(x, y, z) or (\"x y z\") "
	"Set Gravtiy in World") {

	argc; argv;
        float x, y, z;
	if(0 != ODEOneOrThree(argc,argv,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		dWorldSetGravity(object->world, x, y, z);
	}
}

ConsoleMethod(tdWorld, GetGravity, const char*, 2, 2,
	"() "
	"Get Gravtiy in World") {

	argc; argv;
	dVector3 gravity;
	char *ret = Con::getReturnBuffer(256);

	dWorldGetGravity(object->world, gravity);

	dSprintf(ret, 256, "%f %f %f", gravity[0], gravity[1], gravity[2]);

	return ret;
}

ConsoleMethod(tdWorld, SetERP, void, 3, 3,
	"(erp) "
	"Set World Error Reduction Parameter") {

	argc; argv;
	dWorldSetERP(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetERP, F32, 2, 2,
	"() "
	"Get World Error Reduction Parameter") {

	return dWorldGetERP(object->world);
}

ConsoleMethod(tdWorld, SetCFM, void, 3, 3,
	"(cfm) "
	"Set World Constraint Force Mixing") {

	argc; argv;
	dWorldSetCFM(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetCFM, F32, 2, 2,
	"() "
	"Get World Constraint Force Mixing") {

	return dWorldGetCFM(object->world);
}

ConsoleMethod(tdWorld, Step, void, 3, 3,
	"(stepsize) "
	"Step") {

	argc; argv;
	dWorldStep(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, QuickStep, void, 3, 3,
	"(stepsize) "
	"QuickStep") {

	argc; argv;
	dWorldQuickStep(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, SetQuickStepNumIterations, void, 3, 3,
	"(num) "
	"Set Quick Step Num Iterations") {

	argc; argv;
	dWorldSetQuickStepNumIterations(object->world, dAtoi(argv[2]));
}

ConsoleMethod(tdWorld, GetQuickStepNumIterations, S32, 2, 2,
	"() "
	"Get Quick Step Num Iterations") {

	return dWorldGetQuickStepNumIterations(object->world);
}

ConsoleMethod(tdWorld, SetQuickStepW, void, 3, 3,
	"(param) "
	"Set Quick Step W") {

	argc; argv;
	dWorldSetQuickStepW(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetQuickStepW, F32, 2, 2,
	"() "
	"Get Quick Step W") {

	return dWorldGetQuickStepW(object->world);
}

ConsoleMethod(tdWorld, SetContactMaxCorrectingVel, void, 3, 3,
	"(vel) "
	"Set Max Correcting Velocity") {

	argc; argv;
	dWorldSetContactMaxCorrectingVel(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetContactMaxCorrectingVel, F32, 2, 2,
	"() "
	"Get Max Correcting Velocity") {

	return dWorldGetContactMaxCorrectingVel(object->world);
}

ConsoleMethod(tdWorld, SetContactSurfaceLayer, void, 3, 3,
	"(depth) "
	"Set Contact Surface Layer") {

	argc; argv;
	dWorldSetContactSurfaceLayer(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetContactSurfaceLayer, F32, 2, 2,
	"() "
	"Get Contact Surface Layer") {

	return dWorldGetContactSurfaceLayer(object->world);
}

ConsoleMethod(tdWorld, StepFast1, void, 4, 4,
	"(stepsize, maxiterations) "
	"StepFast1") {

	argc; argv;
	dWorldStepFast1(object->world, dAtof(argv[2]), dAtoi(argv[3]));
}

ConsoleMethod(tdWorld, SetAutoEnableDepthSF1, void, 3, 3,
	"(autoEnableDepth) "
	"Set Auto Enable Depth for StepFast1") {

	argc; argv;
	dWorldSetAutoEnableDepthSF1(object->world, dAtoi(argv[2]));
}

ConsoleMethod(tdWorld, GetAutoEnableDepthSF1, S32, 2, 2,
	"() "
	"Get Auto Enable Depth for StepFast1") {

	return dWorldGetAutoEnableDepthSF1(object->world);
}

ConsoleMethod(tdWorld, ImpulseToForce, const char *, 4, 6,
	"(stepsize, ix, iy, iz) or (stepsize, \"ix iy iz\") "
	"Work out force neccesary to apply an impulse") {

	argc; argv;
	char *ret = Con::getReturnBuffer(256);
	dVector3 f;
	float x, y, z;
	if(0 != ODEOneOrThree(argc,argv + 1,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		dWorldImpulseToForce(object->world, dAtof(argv[2]), x, y, z, f);
		dSprintf(ret, 256, "%f %f %f", f[0], f[1], f[2]);
	}

	return ret;
}

ConsoleMethod(tdWorld, SetAutoDisableLinearThreshold, void, 3, 3,
	"(linear_threshold) "
	"Set threshold for Linear disabling") {

	argc; argv;
	dWorldSetAutoDisableLinearThreshold(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetAutoDisableLinearThreshold, F32, 2, 2,
	"() "
	"Get threshold for Linear disabling") {

	return dWorldGetAutoDisableLinearThreshold(object->world);
}

ConsoleMethod(tdWorld, SetAutoDisableAngularThreshold, void, 3, 3,
	"(Angular_threshold) "
	"Set threshold for Angular disabling") {

	argc; argv;
	dWorldSetAutoDisableAngularThreshold(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetAutoDisableAngularThreshold, F32, 2, 2,
	"() "
	"Get threshold for Angular disabling") {

	return dWorldGetAutoDisableAngularThreshold(object->world);
}

ConsoleMethod(tdWorld, SetAutoDisableSteps, void, 3, 3,
	"(steps) "
	"Set number of steps for disabling") {

	argc; argv;
	dWorldSetAutoDisableSteps(object->world, dAtoi(argv[2]));
}

ConsoleMethod(tdWorld, GetAutoDisableSteps, S32, 2, 2,
	"() "
	"Get number of steps for disabling") {

	return dWorldGetAutoDisableSteps(object->world);
}

ConsoleMethod(tdWorld, SetAutoDisableTime, void, 3, 3,
	"(time) "
	"Set amount of time for disabling") {

	argc; argv;
	dWorldSetAutoDisableTime(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetAutoDisableTime, F32, 2, 2,
	"() "
	"Get amount of time for disabling") {

	return dWorldGetAutoDisableTime(object->world);
}

ConsoleMethod(tdWorld, SetAutoDisableFlag, void, 3, 3,
	"(do_auto_disable) "
	"Enable or disable auto disabling") {

	argc; argv;
	dWorldSetAutoDisableFlag(object->world, dAtoi(argv[2]));
}

ConsoleMethod(tdWorld, GetAutoDisableFlag, S32, 2, 2,
	"() "
	"Check for auto disabling") {

	return dWorldGetAutoDisableFlag(object->world);
}


/* TODO

Done!

*/
