#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include <ode/ode.h>
#include "tcontact.h"
#include "odehelper.h"

tdContact::tdContact() {
	contact.surface.mode = 0;
	contact.surface.mu = 0;
	contact.surface.mu2 = 0;
	contact.surface.bounce = 0;
	contact.surface.bounce_vel = 0;
	contact.surface.soft_erp = 0;
	contact.surface.soft_cfm = 0;
	contact.surface.motion1 = 0;
	contact.surface.motion2 = 0;
	contact.surface.slip1 = 0;
	contact.surface.slip2 = 0;

	contact.geom.depth = 0;
	contact.geom.pos[0] = 0;
	contact.geom.pos[1] = 0;
	contact.geom.pos[2] = 0;
	contact.geom.normal[0] = 0;
	contact.geom.normal[1] = 0;
	contact.geom.normal[2] = 0;
	contact.geom.g1 = 0;
	contact.geom.g2 = 0;

	contact.fdir1[0] = 0;
	contact.fdir1[1] = 0;
	contact.fdir1[2] = 0;
}

bool tdContact::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	return true;
}

void tdContact::onRemove() {
	Parent::onRemove();
}

IMPLEMENT_CONOBJECT(tdContact);                                                   

void tdContact::initPersistFields()
{
	Parent::initPersistFields();

	addField("mu", TypeF32,
		Offset(contact.surface.mu, tdContact),
		"Surface Mu");
	addField("mu2", TypeF32,
		Offset(contact.surface.mu2, tdContact),
		"Surface Mu2");
	addField("bounce", TypeF32,
		Offset(contact.surface.bounce, tdContact),
		"Surface bounce");
	addField("bounce_vel", TypeF32,
		Offset(contact.surface.bounce_vel, tdContact),
		"Surface bounce_vel");
	addField("soft_erp", TypeF32,
		Offset(contact.surface.soft_erp, tdContact),
		"Surface soft_erp");
	addField("soft_cfm", TypeF32,
		Offset(contact.surface.soft_cfm, tdContact),
		"Surface soft_cfm");
	addField("motion1", TypeF32,
		Offset(contact.surface.motion1, tdContact),
		"Surface motion1");
	addField("motion2", TypeF32,
		Offset(contact.surface.motion2, tdContact),
		"Surface motion2");
	addField("slip1", TypeF32,
		Offset(contact.surface.slip1, tdContact),
		"Surface slip1");
	addField("slip2", TypeF32,
		Offset(contact.surface.slip2, tdContact),
		"Surface slip2");

	addField("depth", TypeF32,
		Offset(contact.geom.depth, tdContact),
		"Contact depth");
}

ConsoleMethod(tdContact, SetPos, void, 3, 5,
	"(x,y,z) or (\"x y z\") "
	"equivalent of ode dContactGeom.pos") {

	argc; argv;
	float x,y,z;
	if(0 != ODEOneOrThree(argc,argv,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		object->contact.geom.pos[0] = x;
		object->contact.geom.pos[1] = y;
		object->contact.geom.pos[2] = z;
	}
}

ConsoleMethod(tdContact, SetNormal, void, 3, 5,
	"(x,y,z) or (\"x y z\") "
	"equivalent of ode dContactGeom.normal") {

	argc; argv;
	float x,y,z;
	if(0 != ODEOneOrThree(argc,argv,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		object->contact.geom.normal[0] = x;
		object->contact.geom.normal[1] = y;
		object->contact.geom.normal[2] = z;
	}
}

ConsoleMethod(tdContact, SetFdir1, void, 3, 5,
	"(x,y,z) or (\"x y z\") "
	"equivalent of ode dContact.fdir1") {

	argc; argv;
	float x,y,z;
	if(0 != ODEOneOrThree(argc,argv,&x,&y,&z)) {
		Con::errorf("Passed incorrect arguments to %s::%s", object->getClassName(), argv[0]);
	} else {
		object->contact.fdir1[0] = x;
		object->contact.fdir1[1] = y;
		object->contact.fdir1[2] = z;
	}
}

ConsoleMethod(tdContact, SetSurfaceMode, void, 4, 4,
	"(flag, yes) "
	"equivalent to setting a flag on dSurfaceParameters.mode") {

	argc; argv;
	const char *flag = argv[2];
	int yes = dAtoi(argv[3]);

	if(0 == dStricmp(flag, "dContactMu2")) {
		if(yes) object->contact.surface.mode |= dContactMu2;
		else object->contact.surface.mode &= !dContactMu2;
	} else if(0 == dStricmp(flag, "dContactFDir1")) {
		if(yes) object->contact.surface.mode |= dContactFDir1;
		else object->contact.surface.mode &= !dContactFDir1;
	} else if(0 == dStricmp(flag, "dContactBounce")) {
		if(yes) object->contact.surface.mode |= dContactBounce;
		else object->contact.surface.mode &= !dContactBounce;
	} else if(0 == dStricmp(flag, "dContactSoftERP")) {
		if(yes) object->contact.surface.mode |= dContactSoftERP;
		else object->contact.surface.mode &= !dContactSoftERP;
	} else if(0 == dStricmp(flag, "dContactSoftCFM")) {
		if(yes) object->contact.surface.mode |= dContactSoftCFM;
		else object->contact.surface.mode &= !dContactSoftCFM;
	} else if(0 == dStricmp(flag, "dContactMotion1")) {
		if(yes) object->contact.surface.mode |= dContactMotion1;
		else object->contact.surface.mode &= !dContactMotion1;
	} else if(0 == dStricmp(flag, "dContactMotion2")) {
		if(yes) object->contact.surface.mode |= dContactMotion2;
		else object->contact.surface.mode &= !dContactMotion2;
	} else if(0 == dStricmp(flag, "dContactSlip1")) {
		if(yes) object->contact.surface.mode |= dContactSlip1;
		else object->contact.surface.mode &= !dContactSlip1;
	} else if(0 == dStricmp(flag, "dContactSlip2")) {
		if(yes) object->contact.surface.mode |= dContactSlip2;
		else object->contact.surface.mode &= !dContactSlip2;
	} else if(0 == dStricmp(flag, "dContactApprox1_1")) {
		if(yes) object->contact.surface.mode |= dContactApprox1_1;
		else object->contact.surface.mode &= !dContactApprox1_1;
	} else if(0 == dStricmp(flag, "dContactApprox1_2")) {
		if(yes) object->contact.surface.mode |= dContactApprox1_2;
		else object->contact.surface.mode &= !dContactApprox1_2;
	} else if(0 == dStricmp(flag, "dContactApprox1")) {
		if(yes) object->contact.surface.mode |= dContactApprox1;
		else object->contact.surface.mode &= !dContactApprox1;
	}
}
