#include "console/simBase.h"
#include "console/consoleObject.h"
#include <ode/ode.h>
#include "tworld.h"

bool tdWorld::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	world = dWorldCreate();
	istorqueworld = 0;
	return true;
}

void tdWorld::onRemove() {
	if(!istorqueworld) {
		dWorldDestroy(world);
	}
	Parent::onRemove();
}

IMPLEMENT_CONOBJECT(tdWorld);

void tdWorld::initPersistFields()
{
	Parent::initPersistFields();
}


ConsoleMethod(tdWorld, SetWorldToTorque, void, 2, 2,
	"() "
	"Set the world to be the one in use in the rest of Torque") {

	// Make this dWorldDestroy(world);
	// world = torqueworld {whatever that is}
	object->istorqueworld = 1;
}

ConsoleMethod(tdWorld, SetGravity, void, 5, 5,
	"(x, y, z) "
	"Set Gravtiy in World") {

	argc; argv;
	dWorldSetGravity(object->world, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdWorld, GetGravity, const char*, 2, 2,
	"() "
	"Get Gravtiy in World") {

	argc; argv;
	dVector3 gravity;
	char *ret = Con::getReturnBuffer(256);

	dWorldGetGravity(object->world, gravity);

	dSprintf(ret, 256, "%f %f %f", gravity[0], gravity[1], gravity[2]);

	return ret;
}

ConsoleMethod(tdWorld, SetERP, void, 3, 3,
	"(erp) "
	"Set World Error Reduction Parameter") {

	argc; argv;
	dWorldSetERP(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetERP, F32, 2, 2,
	"() "
	"Get World Error Reduction Parameter") {

	dWorldGetERP(object->world);
}

ConsoleMethod(tdWorld, SetCFM, void, 3, 3,
	"(cfm) "
	"Set World Constraint Force Mixing") {

	argc; argv;
	dWorldSetCFM(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetCFM, F32, 2, 2,
	"() "
	"Get World Constraint Force Mixing") {

	return dWorldGetCFM(object->world);
}

ConsoleMethod(tdWorld, Step, void, 3, 3,
	"(stepsize) "
	"Step") {

	argc; argv;
	dWorldStep(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, QuickStep, void, 3, 3,
	"(stepsize) "
	"QuickStep") {

	argc; argv;
	dWorldQuickStep(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, SetQuickStepNumIterations, void, 3, 3,
	"(num) "
	"Set Quick Step Num Iterations") {

	argc; argv;
	dWorldSetQuickStepNumIterations(object->world, dAtoi(argv[2]));
}

ConsoleMethod(tdWorld, GetQuickStepNumIterations, S32, 2, 2,
	"() "
	"Get Quick Step Num Iterations") {

	return dWorldGetQuickStepNumIterations(object->world);
}

ConsoleMethod(tdWorld, SetQuickStepW, void, 3, 3,
	"(param) "
	"Set Quick Step W") {

	argc; argv;
	dWorldSetQuickStepW(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetQuickStepW, F32, 2, 2,
	"() "
	"Get Quick Step W") {

	return dWorldGetQuickStepW(object->world);
}

ConsoleMethod(tdWorld, SetContactMaxCorrectingVel, void, 3, 3,
	"(vel) "
	"Set Max Correcting Velocity") {

	argc; argv;
	dWorldSetContactMaxCorrectingVel(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetContactMaxCorrectingVel, F32, 2, 2,
	"() "
	"Get Max Correcting Velocity") {

	return dWorldGetContactMaxCorrectingVel(object->world);
}

ConsoleMethod(tdWorld, SetContactSurfaceLayer, void, 3, 3,
	"(depth) "
	"Set Contact Surface Layer") {

	argc; argv;
	dWorldSetContactSurfaceLayer(object->world, dAtof(argv[2]));
}

ConsoleMethod(tdWorld, GetContactSurfaceLayer, F32, 2, 2,
	"() "
	"Get Contact Surface Layer") {

	return dWorldGetContactSurfaceLayer(object->world);
}

ConsoleMethod(tdWorld, StepFast1, void, 4, 4,
	"(stepsize, maxiterations) "
	"StepFast1") {

	argc; argv;
	dWorldStepFast1(object->world, dAtof(argv[2]), dAtoi(argv[3]));
}

ConsoleMethod(tdWorld, SetAutoEnableDepthSF1, void, 3, 3,
	"(autoEnableDepth) "
	"Set Auto Enable Depth for StepFast1") {

	argc; argv;
	dWorldSetAutoEnableDepthSF1(object->world, dAtoi(argv[2]));
}

ConsoleMethod(tdWorld, GetAutoEnableDepthSF1, S32, 2, 2,
	"() "
	"Get Auto Enable Depth for StepFast1") {

	return dWorldGetAutoEnableDepthSF1(object->world);
}


/* TODO
void dWorldImpulseToForce (dWorldID, dReal stepsize,
                           dReal ix, dReal iy, dReal iz, dVector3 force);


dReal dWorldGetAutoDisableLinearThreshold (dWorldID);
void  dWorldSetAutoDisableLinearThreshold (dWorldID, dReal linear_threshold);
dReal dWorldGetAutoDisableAngularThreshold (dWorldID);
void  dWorldSetAutoDisableAngularThreshold (dWorldID, dReal angular_threshold);
int   dWorldGetAutoDisableSteps (dWorldID);
void  dWorldSetAutoDisableSteps (dWorldID, int steps);
dReal dWorldGetAutoDisableTime (dWorldID);
void  dWorldSetAutoDisableTime (dWorldID, dReal time);
int   dWorldGetAutoDisableFlag (dWorldID);
void  dWorldSetAutoDisableFlag (dWorldID, int do_auto_disable);

dReal dBodyGetAutoDisableLinearThreshold (dBodyID);
void  dBodySetAutoDisableLinearThreshold (dBodyID, dReal linear_threshold);
dReal dBodyGetAutoDisableAngularThreshold (dBodyID);
void  dBodySetAutoDisableAngularThreshold (dBodyID, dReal angular_threshold);
int   dBodyGetAutoDisableSteps (dBodyID);
void  dBodySetAutoDisableSteps (dBodyID, int steps);
dReal dBodyGetAutoDisableTime (dBodyID);
void  dBodySetAutoDisableTime (dBodyID, dReal time);
int   dBodyGetAutoDisableFlag (dBodyID);
void  dBodySetAutoDisableFlag (dBodyID, int do_auto_disable);
void  dBodySetAutoDisableDefaults (dBodyID);

*/
