//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// --------------------------------------------------------------------
// Initialise Client.
// --------------------------------------------------------------------
function initialiseClient()
{
	// Initialise Base Client.
	InitBaseClient();
	
	// Key-Bindings.
	GlobalActionMap.bind(keyboard, tilde, ToggleConsole);
	GlobalActionMap.bindCmd(keyboard, "alt enter", "", "toggleFullScreen();");
	

	// Initialise Canvas.
	InitCanvas("T2D ODE Phyiscs Demo");

	
	// Load-up GUIs.
	exec("./mainScreenGui.gui");

	// Set GUI.
	Canvas.setContent(mainScreenGui);
	// Set Cursor.
	Canvas.setCursor(DefaultCursor);
	
   // Setup Scene.

	initialiseODE();
	$numodeobjects = 40;
	$damping = 0;
	$musicplaying = 1;
	GUIDampingValue.setValue("Off");
	$dampingfactor = -0.1;
	setupODEworld($numodeobjects);

	setupT2DScene();

	alxPlay(backgroundMusic);
}


// --------------------------------------------------------------------
// Destroy Client.
//
// Here we destroy the SceneGraph.
// --------------------------------------------------------------------
function destroyClient()
{
	// Destroy fxSceneGraph2D.
	if ( isObject(t2dSceneGraph) )
		t2dSceneGraph.delete();	
	shutdownODE();
}


// --------------------------------------------------------------------
// Setup T2D Scene.
// --------------------------------------------------------------------
function setupT2DScene()
{
	// Create fxSceneGraph2D.
	new fxSceneGraph2D(t2dSceneGraph);
	
	// Associate Scenegraph with Window.
	sceneWindow2D.setSceneGraph( t2dSceneGraph );
	
	// Set Camera Position to be centered on (0,0) with
	// view width/height of (100/80).
	sceneWindow2D.setCurrentCameraPosition( "0 0 400 300" );

	
	// ************************************************************************
	//
	// Add your custom code here...
	//
	// ************************************************************************
	createimagemaps();
	
	for(%i=0;%i<$numodeobjects;%i++) {
		$showobj[%i] = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
		$showobj[%i].odeobj = $odebody[%i];

		$showobj[%i].setSize("5 5");
		$showobj[%i].setImageMap(linkImageMap);
		$showobj[%i].setVisible(1);
		$showobj[%i].setPosition(odeGet2DPos(%i));

		$showobj[%i].setGroup( 1 );
		$showobj[%i].setLayer( 1 );
		$showobj[%i].setCollisionActive( true, false );
		$showobj[%i].setCollisionPolyPrimitive( 20 );
		$showobj[%i].setCollisionMasks( BIT(2), BIT(2) );
		$showobj[%i].setCollisionCallback( true );
	}


	$ship = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
	$ship.setGroup( 2 );
	$ship.setLayer( 2 );
	$ship.setPosition("-40 -15");
	$ship.setSize( "60 60" );
	$ship.setVisible(1);
	$ship.setImageMap( playershipImageMap );
	$ship.setCollisionActive( false, true );
	$ship.setCollisionPolyCustom( 4, "-1 0 -0.1 -0.6 0.98 0.15 -0.1 0.7" );
	$ship.setCollisionMasks( BIT(1), BIT(1) );
	$ship.setCollisionCallback( false );

	$ship = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
	$ship.setGroup( 2 );
	$ship.setLayer( 2 );
	$ship.setPosition("40 15");
	$ship.setSize( "60 60" );
	$ship.setVisible(1);
	$ship.setImageMap( playershipImageMap );
	$ship.setCollisionActive( false, true );
	$ship.setCollisionPolyCustom( 4, "-1 0 -0.1 -0.6 0.98 0.15 -0.1 0.7" );
	$ship.setCollisionMasks( BIT(1), BIT(1) );
	$ship.setCollisionCallback( false );

	new ActionMap(playerMap);
		playerMap.bindCmd(keyboard, "space", "changegravity();", "");
		playerMap.bindCmd(keyboard, "d", "dampingtoggle();", "");
		playerMap.bindCmd(keyboard, "s", "soundtoggle();", "");
		playerMap.bindCmd(keyboard, "a", "killgravity();", "");
	playerMap.push();

	crankode();
	
}


function createimagemaps() {
	datablock fxImageMapDatablock2D(linkImageMap) {
		mode = full;
		textureName = "~/client/images/gglogo";
	};

	datablock fxImageMapDatablock2D(playershipImageMap) {
		mode = full;
		textureName = "~/client/images/playerShip";
	};

	datablock fxCollisionMaterialDatablock2D(immovableMaterial)
	{
		friction = 0.0;
		restitution = 0.0;
		relaxation = 0.5;
		density = 0.0;
		forceScale = 0;
		damping = 0.0;
	};

	datablock fxCollisionMaterialDatablock2D(standardMaterial)
	{
		friction = 0.3;
		restitution = 0.0;
		relaxation = 0.5;
		density = 0.01;
		forceScale = 1;
		damping = 0.1;
	};

	new AudioDescription(AudioLooping)
	{
		volume   = 1.0;
		isLooping= true;
		is3D     = false;
		type     = 0;
	};

	new AudioProfile(backgroundMusic)
	{
		filename = "~/client/music/music1.ogg";
		description = "AudioLooping";
		preload = true;
	};

}

function crankode() {
	tickODE();

	if($damping == 1) {
		for(%i=0;%i<$numodeobjects;%i++) {
			$odebody[%i].Damp($dampingfactor);
		}
	}

	for(%i=0;%i<$numodeobjects;%i++) {
		$showobj[%i].setPosition(odeGet2DPos(%i));
		%rotation = mRadtoDeg(getWord($odebody[%i].GetEulerAngles(),2));
		$showobj[%i].setRotation(%rotation);
	}

	$odecollisionjg.Empty();

	schedule(30, 0, crankode);
}

function changegravity() {
	%mousepos = sceneWindow2D.getMousePosition();
	%mousex = getWord(%mousepos,0);
	%mousey = getWord(%mousepos,1);
	
	$odeworld.SetGravity(%mousex * 0.001, %mousey * 0.001, 0);
}

function killgravity() {
	$odeworld.SetGravity(0,0,0);
}

function soundtoggle() {
	echo("Toggle Music");
	if($musicplaying == 1) {
		$musicplaying = 0;
		alxStop(backgroundMusic);
	} else {
		$musicplaying = 1;
		alxPlay(backgroundMusic);
	}
}

function dampingtoggle() {
	if($damping == 0) { GUIDampingValue.setValue("On:" SPC $dampingfactor); $damping=1; }
	else { GUIDampingValue.setValue("Off"); $damping = 0; }
}

function mMin(%a, %b) {
	if(%a < %b) return %a;
	else return %b;
}

function fxSceneObject2D::onCollision( %srcObj, %dstObj, %srcRef,
	%dstRef, %time, %normal, %contactCount, %contacts ) {

	%c = new tdContact();
	%normalx = getWord(%normal,0);
	%normaly = getWord(%normal,1);
	%scale = mMin(getWord(%srcObj.getSize(),0), getWord(%dstObj.getSize(),0)) / 2;
	%c.SetNormal(%normalx, %normaly, 0);
	%c.SetPos(getWord(%contacts,0), getWord(%contacts,1), 0);

	%c.depth=%scale * getPenetrationDepth(%srcObj, %dstObj);
	%c.soft_cfm=0.99;
	%c.soft_erp=0.99;
	%c.SetSurfaceMode("dContactSoftERP",1);
	%c.SetSurfaceMode("dContactSoftCFM",1);

	%j = new tdJoint();
	%j.CreateContact($odeworld, $odecollisionjg, %c);
	%j.Attach(%srcObj.odeobj, %dstObj.odeobj);
}



// Thanks to Matt "King Tut BoB" Langley for this

function getPenetrationDepth(%srcObj, %dstObj)
{
	%size = %srcObj.getSize();
	%sizeX = getWord(%size, 0);
	%sizeY = getWord(%size, 1);

	%srcPos = %srcObj.getPosition();
	%srcPosX = getWord(%srcPos, 0);
	%srcPosY = getWord(%srcPos, 1);

	%dstPos = %dstObj.getPosition();

	%angle = angleBetween2D(%srcPos, %dstPos);
	%avg = ((%sizeX / 2) + (%sizeY / 2)) / 2;


	%valX = (%avg) * (mCos(mDegToRad(%angle)));
	%valY = (%avg) * (mSin(mDegToRad(%angle)));
	%valY = -(%valY);

	%valX += %srcPosX;
	%valY += %srcPosY;


	%point = %dstObj.getLocalPoint(%valX SPC %valY);

	%pointX = 1 - (mAbs(getWord(%point, 0)));
	%pointY = 1 - (mAbs(getWord(%point, 1)));

	%depth = (%pointX + %pointY) / 2; 

	return %depth;
}
