#include "console/simBase.h"
#include "console/consoleObject.h"
#include "console/consoleTypes.h"
#include <ode/ode.h>
#include "tbody.h"
#include "tworld.h"
#include "tmass.h"

tdBody::tdBody() {
	worldsim = 0;
}

bool tdBody::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}

	tdWorld *w;
	w = (tdWorld *)Sim::findObject(worldsim);

	if(NULL == w) {
		iscreated = 0;
	} else {
		body = dBodyCreate(w->world);
		iscreated = 1;
	}

	return true;
}

void tdBody::onRemove() {
	if(iscreated) {
		dBodyDestroy(body);
	}
	Parent::onRemove();
}

IMPLEMENT_CONOBJECT(tdBody);                                                   

void tdBody::initPersistFields()
{
	Parent::initPersistFields();

	addField("worldsim", TypeS32,
		Offset(worldsim, tdBody), "The tdWorld the body is in");
}

ConsoleMethod(tdBody, Create, bool, 3, 3,
    "(world) "
    "Create Body in World") {

    argc; argv;
	tdWorld *w;
	w = (tdWorld *)Sim::findObject(dAtoi(argv[2]));
	if(NULL == w) {
		return 0;
	}

	object->body = dBodyCreate(w->world);
	object->iscreated = 1;
	return 1;
}

ConsoleMethod(tdBody, SetPosition, void, 5, 5,
    "(x,y,z) "
    "Set Body's Position") {

    argc; argv;
	dBodySetPosition(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, GetPosition, const char *, 2, 2,
	"() "
	"Get Body's Position") {

	char *ret = Con::getReturnBuffer(256);
	const dReal *p;

	p = dBodyGetPosition(object->body);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, SetLinearVel, void, 5, 5,
    "(x,y,z) "
    "Set Body's Linear Velocity") {

    argc; argv;
	dBodySetLinearVel(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, GetLinearVel, const char *, 2, 2,
	"() "
	"Get Body's Linear Velocity") {

	char *ret = Con::getReturnBuffer(256);
	const dReal *p;

	p = dBodyGetLinearVel(object->body);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, SetAngularVel, void, 5, 5,
    "(x,y,z) "
    "Set Body's Angular Velocity") {

    argc; argv;
	dBodySetAngularVel(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, GetAngularVel, const char *, 2, 2,
	"() "
	"Get Body's Angular Velocity") {

	char *ret = Con::getReturnBuffer(256);
	const dReal *p;

	p = dBodyGetAngularVel(object->body);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, AddForce, void, 5, 5,
    "(fx,fy,fz) "
    "Add a Force to a Body") {

    argc; argv;
	dBodyAddForce(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, AddTorque, void, 5, 5,
    "(fx,fy,fz) "
    "Add a Torque to a Body") {

    argc; argv;
	dBodyAddTorque(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, AddRelForce, void, 5, 5,
    "(fx,fy,fz) "
    "Add a Relative Force to a Body") {

    argc; argv;
	dBodyAddRelForce(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, AddRelTorque, void, 5, 5,
    "(fx,fy,fz) "
    "Add a Relative Torque to a Body") {

    argc; argv;
	dBodyAddRelTorque(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, AddForceAtPos, void, 8, 8,
    "(fx,fy,fz,px,py,pz) "
    "Add a Force to a Body at a specific Position") {

    argc; argv;
	dBodyAddForceAtPos(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]), dAtof(argv[6]),
		dAtof(argv[7]));
}

ConsoleMethod(tdBody, AddForceAtRelPos, void, 8, 8,
    "(fx,fy,fz,px,py,pz) "
    "Add a Force to a Body at a Relative Position") {

    argc; argv;
	dBodyAddForceAtRelPos(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]), dAtof(argv[6]),
		dAtof(argv[7]));
}

ConsoleMethod(tdBody, AddRelForceAtPos, void, 8, 8,
    "(fx,fy,fz,px,py,pz) "
    "Add a Relative Force to a Body at a Position") {

    argc; argv;
	dBodyAddRelForceAtPos(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]), dAtof(argv[6]),
		dAtof(argv[7]));
}

ConsoleMethod(tdBody, AddRelForceAtRelPos, void, 8, 8,
    "(fx,fy,fz,px,py,pz) "
    "Add a Relative Force to a Body at a Relative Position") {

    argc; argv;
	dBodyAddRelForceAtRelPos(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), dAtof(argv[5]), dAtof(argv[6]),
		dAtof(argv[7]));
}

ConsoleMethod(tdBody, SetForce, void, 5, 5,
    "(x,y,z) "
    "Set Body's Force") {

    argc; argv;
	dBodySetForce(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, GetForce, const char *, 2, 2,
	"() "
	"Get Body's Force") {

	char *ret = Con::getReturnBuffer(256);
	const dReal *p;

	p = dBodyGetForce(object->body);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, SetTorque, void, 5, 5,
    "(x,y,z) "
    "Set Body's Torque") {

    argc; argv;
	dBodySetTorque(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, GetTorque, const char *, 2, 2,
	"() "
	"Get Body's Torque") {

	char *ret = Con::getReturnBuffer(256);
	const dReal *p;

	p = dBodyGetTorque(object->body);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, GetRelPointPos, const char *, 5, 5,
	"(px,py,pz) "
	"Get Body's Relative Position") {

    argc; argv;
	char *ret = Con::getReturnBuffer(256);
	dVector3 p;

	dBodyGetRelPointPos(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), p);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, GetRelPointVel, const char *, 5, 5,
	"(px,py,pz) "
	"Get Body's Relative Velocity") {

    argc; argv;
	char *ret = Con::getReturnBuffer(256);
	dVector3 p;

	dBodyGetRelPointVel(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), p);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, GetPosRelPoint, const char *, 5, 5,
	"(px,py,pz) "
	"Get Body's Relative Position") {

    argc; argv;
	char *ret = Con::getReturnBuffer(256);
	dVector3 p;

	dBodyGetPosRelPoint(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), p);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, VectorToWorld, const char *, 5, 5,
	"(px,py,pz) "
	"Get Body's Vector to World") {

    argc; argv;
	char *ret = Con::getReturnBuffer(256);
	dVector3 p;

	dBodyVectorToWorld(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), p);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, VectorFromWorld, const char *, 5, 5,
	"(px,py,pz) "
	"Get Body's Vector from World") {

    argc; argv;
	char *ret = Con::getReturnBuffer(256);
	dVector3 p;

	dBodyVectorFromWorld(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]), p);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, SetFiniteRotationMode, void, 2, 2,
	"(mode) "
	"Set a body's finite rotation mode") {

    argc; argv;
	dBodySetFiniteRotationMode(object->body, dAtoi(argv[2]));
}

ConsoleMethod(tdBody, GetFiniteRotationMode, S32, 2, 2,
	"() "
	"Get a body's finite rotation mode") {

	return dBodyGetFiniteRotationMode(object->body);
}

ConsoleMethod(tdBody, SetFiniteRotationAxis, void, 5, 5,
	"(x,y,z) "
	"Set Body's Finite Rotation Axis") {

    argc; argv;

	dBodySetFiniteRotationAxis(object->body, dAtof(argv[2]), dAtof(argv[3]),
		dAtof(argv[4]));
}

ConsoleMethod(tdBody, dBodyGetFiniteRotationAxis, const char *, 2, 2,
	"() "
	"Get Body's Finite Rotation Axis") {

    argc; argv;
	char *ret = Con::getReturnBuffer(256);
	dVector3 p;

	dBodyGetFiniteRotationAxis(object->body, p);

	dSprintf(ret, 256, "%f %f %f", p[0], p[1], p[2]);
	return ret;
}

ConsoleMethod(tdBody, Enable, void, 2, 2,
	"() "
	"Enable Body") {

	dBodyEnable(object->body);
}

ConsoleMethod(tdBody, Disable, void, 2, 2,
	"() "
	"Disable Body") {

	dBodyDisable(object->body);
}

ConsoleMethod(tdBody, IsEnabled, S32, 2, 2,
	"() "
	"See if body is Enabled") {

	return dBodyIsEnabled(object->body);
}

ConsoleMethod(tdBody, SetGravityMode, void, 2, 2,
	"(mode) "
	"Set a body's gravity mode") {

    argc; argv;
	dBodySetGravityMode(object->body, dAtoi(argv[2]));
}

ConsoleMethod(tdBody, GetGravityMode, S32, 2, 2,
	"() "
	"Get a body's gravity mode") {

	return dBodyGetGravityMode(object->body);
}

ConsoleMethod(tdBody, GetNumJoints, S32, 2, 2,
	"() "
	"Get a number of joints on a body") {

	return dBodyGetNumJoints(object->body);
}

ConsoleMethod(tdBody, SetMass, void, 3, 3,
	"(mass) "
	"Set a body's mass") {

	argc;argv;

	tdMass *m;
	m = (tdMass *)Sim::findObject(dAtoi(argv[2]));
	dBodySetMass(object->body, &m->mass);

	object->mass = dAtoi(argv[2]);
}

ConsoleMethod(tdBody, GetMass, S32, 2, 2,
	"() "
	"Get a body's mass") {

	return object->mass;
}

ConsoleMethod(tdBody, Damp, void, 2, 3,
	"([factor]) "
	"Damp a body's linear and angular velocity by factor [try -0.02]") {

	const dReal *v;
	dReal factor;

	argc; argv;
	if(argc == 2) {
		factor = -0.02;
	} else {
		factor = dAtof(argv[2]);
	}
	v = dBodyGetLinearVel(object->body);
	dBodyAddForce(object->body, v[0]*factor, v[1]*factor, v[2]*factor);
	
	v = dBodyGetAngularVel(object->body);
	dBodyAddTorque(object->body, v[0]*factor, v[1]*factor, v[2]*factor);
}
/* TODO:

void  dBodySetData (dBodyID, void *data);
void *dBodyGetData (dBodyID);

void dBodySetRotation   (dBodyID, const dMatrix3 R);
void dBodySetQuaternion (dBodyID, const dQuaternion q);
const dReal * dBodyGetRotation   (dBodyID);     
const dReal * dBodyGetQuaternion (dBodyID);

dJointID dBodyGetJoint (dBodyID, int index);

*/
