// --------------------------------------------------------------------
// Initialise ODE.
// --------------------------------------------------------------------
function initialiseODE()
{
	$odeworld = new tdWorld();
	$odeworld.SetCFM(0.2);
	$odeworld.SetERP(0.9);

	$odecollisionjg = new tdJointGroup();
}

function tickODE()
{
	$odeworld.QuickStep(0.1);
	$odeworld.QuickStep(0.1);
	$odeworld.QuickStep(0.1);
}

function shutdownODE()
{
	$odejointgroup.Empty();
	$odecollisionjg.Empty();
	$odeworld.delete();
}

function setupODEworld(%numobjects)
{
	for(%i = 0; %i < %numobjects; %i++) {
		$odemass[%i] = new tdMass();
		$odemass[%i].SetSphereTotal(0.5, 0.5);

		$odebody[%i] = new tdBody() { worldsim = $odeworld; };
		$odebody[%i].SetMass($odemass[%i]);

		$odebody[%i].SetPosition(0, 1+%i, 0);
	}

	$odejointgroup = new tdJointGroup();

	$firstlink = new tdJoint();
	$firstlink.CreateFixed($odeworld, $odejointgroup);
	$firstlink.Attach(0,$odebody[0]);

	for(%i = 0; %i < %numobjects-1; %i++) {
		$odejoint[%i] = new tdJoint();
		$odejoint[%i].CreateBall($odeworld, $odejointgroup);
		$odejoint[%i].Attach($odebody[%i], $odebody[%i+1]);
		$odejoint[%i].SetBallAnchor(0, 1.5 + %i, 0);
		// $odejoint[%i].SetHingeAxis(0, 0, 1);
	}
}

function odeGet2DPos(%objectnum)
{
	return getWord($odebody[%objectnum].GetPosition(),0) SPC
		getWord($odebody[%objectnum].GetPosition(),1);
}
