//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Load up common script base
//-----------------------------------------------------------------------------
loadDir("common");


//-----------------------------------------------------------------------------
// Load Client Preferences.
//-----------------------------------------------------------------------------
exec("./defaults.cs");
exec("./client/prefs.cs");

exec("./odesetup.cs");

//-----------------------------------------------------------------------------
// T2D Package.
//-----------------------------------------------------------------------------
package T2D
{
	// Start-up.
	function onStart()
	{
		Parent::onStart();
		echo("\n--------- Initializing MOD: T2D ---------");
		
		// Load Client Scripts.
		exec("./client/client.cs");
		
		// Initialise Client.
		initialiseClient();
	}
	
	// Shutdown.
	function onExit()
	{
		// Destroy Client.
		destroyClient();
		
		echo("Exporting client prefs");
		export("$pref::*", "./client/prefs.cs", false);
		
		echo("Exporting client config");
		if (isObject(moveMap))
		  moveMap.save("./client/config.cs", false);
		
		// Call Parent.		
		Parent::onExit();
	}
	
	function quitapp() { quit(); }
	
};


//-----------------------------------------------------------------------------
// Activate Package.
//-----------------------------------------------------------------------------
activatePackage(T2D);

