//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// --------------------------------------------------------------------
// Initialise Client.
// --------------------------------------------------------------------
function initialiseClient()
{
	// Initialise Base Client.
	InitBaseClient();
	
	// Key-Bindings.
	GlobalActionMap.bind(keyboard, tilde, ToggleConsole);
	GlobalActionMap.bindCmd(keyboard, "alt enter", "", "toggleFullScreen();");
	

	// Initialise Canvas.
	InitCanvas("T2D");

	
	// ************************************************************************
	// Load-up Demo Datablocks.
	// NOTE:-	Remove this is you're not interested in running the demos
	//			or any or the default datablocks.
	// ************************************************************************
	// Load-up GUIs.
	exec("./mainScreenGui.gui");
	
	// Set GUI.
	Canvas.setContent(mainScreenGui);
	// Set Cursor.
	Canvas.setCursor(DefaultCursor);
	
   // Setup Scene.

	initialiseODE();
	$numodeobjects = 100;
	$damping = 0;
	GUIDampingValue.setValue("Off");
	$dampingfactor = -0.1;
	setupODEworld($numodeobjects);

	setupT2DScene();

}


// --------------------------------------------------------------------
// Destroy Client.
//
// Here we destroy the SceneGraph.
// --------------------------------------------------------------------
function destroyClient()
{
	// Destroy fxSceneGraph2D.
	if ( isObject(t2dSceneGraph) )
		t2dSceneGraph.delete();	
	shutdownODE();
}


// --------------------------------------------------------------------
// Setup T2D Scene.
// --------------------------------------------------------------------
function setupT2DScene()
{
	// Create fxSceneGraph2D.
	new fxSceneGraph2D(t2dSceneGraph);
	
	// Associate Scenegraph with Window.
	sceneWindow2D.setSceneGraph( t2dSceneGraph );
	
	// Set Camera Position to be centered on (0,0) with
	// view width/height of (100/80).
	sceneWindow2D.setCurrentCameraPosition( "0 0 400 300" );

	
	// ************************************************************************
	//
	// Add your custom code here...
	//
	// ************************************************************************
	createimagemaps();
	
	for(%i=0;%i<$numodeobjects;%i++) {
		$showobj[%i] = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
		$showobj[%i].odeobj = $odebody[%i];

		$showobj[%i].setSize("5 5");
		$showobj[%i].setImageMap(linkImageMap);
		$showobj[%i].setVisible(1);
		$showobj[%i].setPosition(odeGet2DPos(%i));

		$showobj[%i].setGroup( 1 );
		$showobj[%i].setLayer( 1 );
		$showobj[%i].setCollisionActive( true, false );
		$showobj[%i].setCollisionPolyPrimitive( 20 );
		$showobj[%i].setCollisionMasks( BIT(2), BIT(2) );
		$showobj[%i].setCollisionCallback( true );

	}

	$ship = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
	$ship.setGroup( 2 );
	$ship.setLayer( 2 );
	$ship.setPosition("-30 0");
	$ship.setSize( "50 50" );
	$ship.setVisible(1);
	$ship.setImageMap( playershipImageMap );
	$ship.setCollisionActive( false, true );
	$ship.setCollisionPolyCustom( 4, "-1 0 -0.1 -0.6 0.98 0.15 -0.1 0.7" );
	// $ship.setCollisionPolyCustom( 21,
		// "-0.9843 -0.1250 -0.2656 -0.0937 -0.1484 -0.5156 -0.1328 -0.5937" SPC
		// "0.1640 -0.5000 0.3203 -0.3125 0.5000 -0.2968 0.7187 -0.1406" SPC
		// "0.9843 0.1093 0.9609 0.2187 0.8125 0.2812 0.3593 0.2968" SPC
		// "0.2890 0.3750 0.1718 0.3750 0.0312 0.6718 0.0078 0.7968" SPC
		// "-0.1953 0.7031 -0.2500 0.5156 -0.4218 0.2500 -0.8906 0.1093" SPC
		// "-0.9843 0.0312");
	$ship.setCollisionMasks( BIT(1), BIT(1) );
	$ship.setCollisionCallback( false );


	new ActionMap(playerMap);
		playerMap.bindCmd(keyboard, "space", "changegravity();", "");
		playerMap.bindCmd(keyboard, "d", "dampingtoggle();", "");
	playerMap.push();

	crankode();
	
}


function createimagemaps() {
	datablock fxImageMapDatablock2D(linkImageMap) {
		mode = full;
		textureName = "~/client/images/gglogo";
	};

	datablock fxImageMapDatablock2D(playershipImageMap) {
		mode = full;
		textureName = "~/client/images/playerShip";
	};
}

function crankode() {
	tickODE();

	if($damping == 1) {
		for(%i=0;%i<$numodeobjects;%i++) {
			$odebody[%i].Damp($dampingfactor);
		}
	}

	for(%i=0;%i<$numodeobjects;%i++) {
		$showobj[%i].setPosition(odeGet2DPos(%i));
	}
	$odecollisionjg.Empty();
	schedule(30, 0, crankode);
}

function changegravity() {
	%mousepos = sceneWindow2D.getMousePosition();
	%mousex = getWord(%mousepos,0);
	%mousey = getWord(%mousepos,1);
	
	$odeworld.SetGravity(%mousex * 0.001, %mousey * 0.001, 0);
}

function dampingtoggle() {
	if($damping == 0) { GUIDampingValue.setValue("On:" SPC $dampingfactor); $damping=1; }
	else { GUIDampingValue.setValue("Off"); $damping = 0; }
}



function fxSceneObject2D::onCollision( %srcObj, %dstObj, %srcRef,
	%dstRef, %time, %normal, %contactCount, %contacts ) {

	%c = new tdContact();
	%c.SetNormal(getWord(%normal,0), getWord(%normal,1), 0);
	%c.SetPos(getWord(%contacts,0), getWord(%contacts,1), 0);
	%c.depth=200 * getPenetrationDepth(%srcObj, %dstObj);

	%j = new tdJoint();
	%j.CreateContact($odeworld, $odecollisionjg, %c);
	%j.Attach(%srcObj.odeobj, %dstObj.odeobj);
}



// Thanks to Matt "King Tut BoB" Langley for this

function getPenetrationDepth(%srcObj, %dstObj)
{
	%size = %srcObj.getSize();
	%sizeX = getWord(%size, 0);
	%sizeY = getWord(%size, 1);

	%srcPos = %srcObj.getPosition();
	%srcPosX = getWord(%srcPos, 0);
	%srcPosY = getWord(%srcPos, 1);

	%dstPos = %dstObj.getPosition();

	%angle = angleBetween2D(%srcPos, %dstPos);
	%avg = ((%sizeX / 2) + (%sizeY / 2)) / 2;


	%valX = (%avg) * (mCos(mDegToRad(%angle)));
	%valY = (%avg) * (mSin(mDegToRad(%angle)));
	%valY = -(%valY);

	%valX += %srcPosX;
	%valY += %srcPosY;


	%point = %dstObj.getLocalPoint(%valX SPC %valY);

	%pointX = 1 - (mAbs(getWord(%point, 0)));
	%pointY = 1 - (mAbs(getWord(%point, 1)));

	%depth = (%pointX + %pointY) / 2; 

	return %depth;
}
