//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------



// --------------------------------------------------------------------
// Setup T2D Scene.
// --------------------------------------------------------------------
function setupT2DScene()
{
	// Associate Scenegraph with Window.
	spaceScrollerSceneWindow2D.setSceneGraph( spaceSceneGraph2D );
	
	// Set Camera Position.
	spaceScrollerSceneWindow2D.setCurrentCameraPosition( "0 0 100 75" );

	
	// *******************************************************
	// Create Tile-Map Scroller.
	// *******************************************************
	%scrollerMap = new fxTileMap2D() { scenegraph = spaceSceneGraph2D; };
	
	// Load Tile-Map.
	%scrollerMap.loadTileMap("~/client/maps/scroller.map");
	
	// Reference Layers.
	%skyLayer = %scrollerMap.getTileLayer( 0 );
	%mountainsLayer = %scrollerMap.getTileLayer( 1 );
	%buildings1Layer = %scrollerMap.getTileLayer( 2);
	%hillsLayer = %scrollerMap.getTileLayer( 3 );
	%groundLayer = %scrollerMap.getTileLayer( 4 );
	%buildings2Layer = %scrollerMap.getTileLayer( 5 );
	
	// *******************************************************
	// Generate Scrolling Sky
	// *******************************************************
	%skyLayer.setPosition( "0 -10" ); 
	%skyLayer.setSize( "140 60" );
	%skyLayer.setLayer( 31 );
	%skyLayer.setWrap( true, false );
	%skyLayer.setAutoPan( "20 0" );
		
	// *******************************************************
	// Generate Scrolling Mountains
	// *******************************************************
	%mountainsLayer.setPosition( "0 -9" ); 
	%mountainsLayer.setSize( "140 50" );
	%mountainsLayer.setLayer( 30 );
	%mountainsLayer.setWrap( true, false );
	%mountainsLayer.setAutoPan( "30 0" );
		
	// *******************************************************
	// Generate Scrolling Buildings
	// *******************************************************
	%buildings1Layer.setPosition( "0 3" ); 
	%buildings1Layer.setSize( "140 25" );
	%buildings1Layer.setLayer( 29 );
	%buildings1Layer.setWrap( true, false );
	%buildings1Layer.setAutoPan( "40 0" );	

	// *******************************************************
	// Generate Scrolling ground
	// *******************************************************
	%groundLayer.setPosition( "0 28.5" ); 
	%groundLayer.setSize( "140 26" );
	%groundLayer.setLayer( 28 );
	%groundLayer.setWrap( true, false );
	%groundLayer.setAutoPan( "60 0" );

	// *******************************************************
	// Generate Scrolling Dunes
	// *******************************************************
	%hillsLayer.setPosition( "0 11" ); 
	%hillsLayer.setSize( "140 10" );
	%hillsLayer.setLayer( 27 );
	%hillsLayer.setWrap( true, false );
	%hillsLayer.setAutoPan( "50 0" );	
	
	// *******************************************************
	// Generate Scrolling Buildings2
	// *******************************************************
	%buildings2Layer.setPosition( "0 29" ); 
	%buildings2Layer.setSize( "140 31" );
	%buildings2Layer.setLayer( 26 );
	%buildings2Layer.setWrap( true, false );
	%buildings2Layer.setAutoPan( "70 0" );	
	
	
	// *******************************************************
	// Scene Pause Stuff.
	// *******************************************************
	
	// Background.
	new fxScroller2D(scenePauseBackground) { scenegraph = spaceSceneGraph2D; };
	scenePauseBackground.setSize( "100 75" );
	scenePauseBackground.setLayer( 0 );
	scenePauseBackground.setImageMap( pausedBackgroundImageMap );
	scenePauseBackground.setBlendColour("255 255 255 200");
	scenePauseBackground.setRepeat( "4 4" );
	scenePauseBackground.setEnabled( false );
	
	// Message.
	new fxStaticSprite2D(scenePauseMessage) { scenegraph = spaceSceneGraph2D; };
	scenePauseMessage.setSize( "50 25" );
	scenePauseMessage.setLayer( 0 );
	scenePauseMessage.setImageMap( pausedImageMap );
	scenePauseMessage.setEnabled( false );
}


// --------------------------------------------------------------------
// Scene Pause Toggle.
// --------------------------------------------------------------------
function scenePauseToggle()
{
	// Toggle Flag.	
	$spaceScenePauseFlag = !$spaceScenePauseFlag;
	
	// Set Scene Pause.
	spaceSceneGraph2D.setScenePause( $spaceScenePauseFlag );
	
	// Enable/Disable Pause Background/Message.
	scenePauseBackground.setEnabled( $spaceScenePauseFlag );
	scenePauseMessage.setEnabled( $spaceScenePauseFlag );
	
	// Handle Ambient Audio.
	if ( $spaceScenePauseFlag )
		alxStop($spaceAmbientAudio);
	else
		$spaceAmbientAudio = alxPlay( ambient1Audio );
}


// --------------------------------------------------------------------
// Update Scores.
// --------------------------------------------------------------------
function updateScores()
{
	// Update Scores.
	lblSpaceBestScore.setValue( "Best:" SPC $pref::spaceshooter::bestScore );
	lblSpaceCurrentScore.setValue("Score:" SPC $playerScore );
}

