//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// --------------------------------------------------------------------
// Initialise Client.
// --------------------------------------------------------------------
function initialiseClient()
{
	// Initialise Base Client.
	InitBaseClient();
	
	// Key-Bindings.
	GlobalActionMap.bind(keyboard, tilde, ToggleConsole);
	GlobalActionMap.bindCmd(keyboard, "alt enter", "", "toggleFullScreen();");
	

	// Initialise Canvas.
	InitCanvas("T2D");

	
	// ************************************************************************
	// Load-up Demo Datablocks.
	// NOTE:-	Remove this is you're not interested in running the demos
	//			or any or the default datablocks.
	// ************************************************************************
	exec("./demoDatablocks.cs");
	
	
	
	// Load-up Datablocks.	
	exec("./datablocks.cs");
	// Load-up GUIs.
	exec("./mainScreenGui.gui");
	
	// Set GUI.
	Canvas.setContent(mainScreenGui);
	// Set Cursor.
	Canvas.setCursor(DefaultCursor);
	
   // Setup Scene.

	initialiseODE();
	$numodeobjects = 25;
	setupODEworld($numodeobjects);

	setupT2DScene();
}


// --------------------------------------------------------------------
// Destroy Client.
//
// Here we destroy the SceneGraph.
// --------------------------------------------------------------------
function destroyClient()
{
	// Destroy fxSceneGraph2D.
	if ( isObject(t2dSceneGraph) )
		t2dSceneGraph.delete();	
	shutdownODE();
}


// --------------------------------------------------------------------
// Setup T2D Scene.
// --------------------------------------------------------------------
function setupT2DScene()
{
	// Create fxSceneGraph2D.
	new fxSceneGraph2D(t2dSceneGraph);
	
	// Associate Scenegraph with Window.
	sceneWindow2D.setSceneGraph( t2dSceneGraph );
	
	// Set Camera Position to be centered on (0,0) with
	// view width/height of (100/80).
	sceneWindow2D.setCurrentCameraPosition( "0 0 80 50" );

	
	// ************************************************************************
	//
	// Add your custom code here...
	//
	// ************************************************************************
	createimagemaps();
	
	for(%i=0;%i<$numodeobjects;%i++) {
		$showobj[%i] = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
		$showobj[%i].setSize("1 1");
		$showobj[%i].setImageMap(linkImageMap);
		$showobj[%i].setVisible(1);
		$showobj[%i].setPosition(odeGet2DPos(%i));
	}

	new ActionMap(playerMap);
	playerMap.bindCmd(keyboard, "space", "changegravity();", "");
	playerMap.push();


	crankode();
	
}


function createimagemaps() {
	datablock fxImageMapDatablock2D(linkImageMap) {
		mode = full;
		textureName = "~/client/images/gglogo";
	};
}

function crankode() {
	tickODE();

	for(%i=0;%i<$numodeobjects;%i++) {
		$showobj[%i].setPosition(odeGet2DPos(%i));
	}
	schedule(20, 0, crankode);
}

function changegravity() {
	%mousepos = sceneWindow2D.getMousePosition();
	%mousex = getWord(%mousepos,0);
	%mousey = getWord(%mousepos,1);
	
	echo("here, mousex =" SPC %mousex SPC "mousey =" SPC %mousey);
	$odeworld.SetGravity(%mousex * 0.01, %mousey * 0.01, 0);
}
