#include "console/simBase.h"
#include "console/consoleObject.h"
#include <ode/ode.h>
#include "tjoint.h"
#include "tworld.h"
#include "tbody.h"

bool tdJointGroup::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	group = dJointGroupCreate(0);
	return true;
}

void tdJointGroup::onRemove() {
	dJointGroupDestroy(group);
	Parent::onRemove();
}

IMPLEMENT_CONOBJECT(tdJointGroup);

void tdJointGroup::initPersistFields()
{
	Parent::initPersistFields();
}


ConsoleMethod(tdJointGroup, Empty, void, 2, 2,
	"() "
	"Empty Joint Group") {

	dJointGroupEmpty(object->group);
}


bool tdJoint::onAdd() {
	if(!Parent::onAdd()) {
		return false;
	}
	return true;
}

void tdJoint::onRemove() {
	dJointDestroy(joint);
	Parent::onRemove();
}

IMPLEMENT_CONOBJECT(tdJoint);

void tdJoint::initPersistFields()
{
	Parent::initPersistFields();
}



ConsoleMethod(tdJoint, CreateBall, S32, 4, 4,
    "(world, group) "
    "Create Ball & Socket Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateBall(w,g);
	return 1;
}

ConsoleMethod(tdJoint, CreateHinge, S32, 4, 4,
    "(world, group) "
    "Create Hinge Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateHinge(w,g);
	return 1;
}

ConsoleMethod(tdJoint, CreateSlider, S32, 4, 4,
    "(world, group) "
    "Create Slider Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateSlider(w,g);
	return 1;
}

ConsoleMethod(tdJoint, CreateHinge2, S32, 4, 4,
    "(world, group) "
    "Create Hinge2 Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateHinge2(w,g);
	return 1;
}

ConsoleMethod(tdJoint, CreateUniversal, S32, 4, 4,
    "(world, group) "
    "Create Universal Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateUniversal(w,g);
	return 1;
}

ConsoleMethod(tdJoint, CreateFixed, S32, 4, 4,
    "(world, group) "
    "Create Fixed Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateFixed(w,g);
	return 1;
}

ConsoleMethod(tdJoint, CreateNull, S32, 4, 4,
    "(world, group) "
    "Create Null Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateNull(w,g);
	return 1;
}

ConsoleMethod(tdJoint, CreateAMotor, S32, 4, 4,
    "(world, group) "
    "Create AMotor Joint") {

    argc; argv;
	dWorldID w;
	dJointGroupID g;

	w = ((tdWorld *)Sim::findObject(dAtoi(argv[2])))->world;
	g = ((tdJointGroup *)Sim::findObject(dAtoi(argv[3])))->group;
	if(NULL == g || NULL == w) {
		return 0;
	}

	object->joint = dJointCreateAMotor(w,g);
	return 1;
}

ConsoleMethod(tdJoint, Attach, void, 4, 4,
    "(body1, body2) "
    "Attach Joint to Bodies") {

    argc; argv;

	dBodyID b1,b2;

	object->body1 = dAtoi(argv[2]);
	object->body2 = dAtoi(argv[3]);

	b1 = (0!=object->body1)?((tdBody *)Sim::findObject(object->body1))->body:0;
	b2 = (0!=object->body2)?((tdBody *)Sim::findObject(object->body2))->body:0;

	dJointAttach(object->joint, b1, b2);
}

ConsoleMethod(tdJoint, GetType, S32, 2, 2,
    "() "
    "Get Joint Type") {

	return dJointGetType(object->joint);
}

ConsoleMethod(tdJoint, SetBallAnchor, void, 5, 5,
    "(x,y,z) "
    "Set Ball Anchor") {

    argc; argv;
	dJointSetBallAnchor(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetHingeAnchor, void, 5, 5,
    "(x,y,z) "
    "Set Hinge Anchor") {

    argc; argv;
	dJointSetHingeAnchor(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetHingeAxis, void, 5, 5,
    "(x,y,z) "
    "Set Hinge Axis") {

    argc; argv;
	dJointSetHingeAxis(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetHingeParam, void, 4, 4,
    "(param, value) "
    "Set Hinge Parameter") {

    argc; argv;
	dJointSetHingeParam(object->joint, dAtoi(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, AddHingeTorque, void, 3, 3,
    "(torque) "
    "Add Hinge Torque") {

    argc; argv;
	dJointAddHingeTorque(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, SetSliderAxis, void, 5, 5,
    "(x,y,z) "
    "Set Slider Axis") {

    argc; argv;
	dJointSetSliderAxis(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetSliderParam, void, 4, 4,
    "(param, value) "
    "Set Slider Parameter") {

    argc; argv;
	dJointSetSliderParam(object->joint, dAtoi(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, AddSliderForce, void, 3, 3,
    "(force) "
    "Add Slider Force") {

    argc; argv;
	dJointAddSliderForce(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, SetHinge2Anchor, void, 5, 5,
    "(x,y,z) "
    "Set Hinge2 Anchor") {

    argc; argv;
	dJointSetHinge2Anchor(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetHinge2Axis1, void, 5, 5,
    "(x,y,z) "
    "Set Hinge2 Axis1") {

    argc; argv;
	dJointSetHinge2Axis1(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetHinge2Axis2, void, 5, 5,
    "(x,y,z) "
    "Set Hinge2 Axis2") {

    argc; argv;
	dJointSetHinge2Axis2(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetHinge2Param, void, 4, 4,
    "(param, value) "
    "Set Hinge2 Parameter") {

    argc; argv;
	dJointSetHinge2Param(object->joint, dAtoi(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, AddHinge2Torques, void, 4, 4,
    "(torque1, torque2) "
    "Set Hinge2 Torques") {

    argc; argv;
	dJointAddHinge2Torques(object->joint, dAtof(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, SetUniversalAnchor, void, 5, 5,
    "(x,y,z) "
    "Set Universal Anchor") {

    argc; argv;
	dJointSetUniversalAnchor(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetUniversalAxis1, void, 5, 5,
    "(x,y,z) "
    "Set Universal Axis1") {

    argc; argv;
	dJointSetUniversalAxis1(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetUniversalAxis2, void, 5, 5,
    "(x,y,z) "
    "Set Universal Axis2") {

    argc; argv;
	dJointSetUniversalAxis2(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, SetUniversalParam, void, 4, 4,
    "(param, value) "
    "Set Universal Parameter") {

    argc; argv;
	dJointSetUniversalParam(object->joint, dAtoi(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, AddUniversalTorques, void, 4, 4,
    "(torque1, torque2) "
    "Set Universal Torques") {

    argc; argv;
	dJointAddUniversalTorques(object->joint, dAtof(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, SetFixed, void, 2, 2,
    "() "
    "Set Fixed") {

	dJointSetFixed(object->joint);
}

ConsoleMethod(tdJoint, SetAMotorNumAxes, void, 3, 3,
    "(num) "
    "Set Number of Axes on Angular Motor") {

    argc; argv;
	dJointSetAMotorNumAxes(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, SetAMotorAxis, void, 7, 7,
    "(anum, rel, x, y, z) "
    "Set Angular Motor Axis") {

    argc; argv;
	dJointSetAMotorAxis(object->joint, dAtoi(argv[2]),
		dAtoi(argv[3]), dAtof(argv[4]), dAtof(argv[5]),
		dAtof(argv[6]));
}

ConsoleMethod(tdJoint, SetAMotorAngle, void, 4, 4,
    "(anum, angle) "
    "Set Angular Motor Angle") {

    argc; argv;
	dJointSetAMotorAngle(object->joint, dAtoi(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, SetAMotorParam, void, 4, 4,
    "(param, value) "
    "Set Angular Motor Parameter") {

    argc; argv;
	dJointSetAMotorParam(object->joint, dAtoi(argv[2]),
		dAtof(argv[3]));
}

ConsoleMethod(tdJoint, SetAMotorMode, void, 3, 3,
    "(mode) "
    "Set Mode on Angular Motor") {

    argc; argv;
	dJointSetAMotorMode(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, AddAMotorTorques, void, 5, 5,
    "(torque1, torque2, torque3) "
    "Add Torques to Angular Motor") {

    argc; argv;
	dJointAddAMotorTorques(object->joint, dAtof(argv[2]),
		dAtof(argv[3]), dAtof(argv[4]));
}

ConsoleMethod(tdJoint, GetBallAnchor, const char *, 2, 2,
	"() "
	"Get ball Anchor") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetBallAnchor(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetBallAnchor2, const char *, 2, 2,
	"() "
	"Get ball Anchor2") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetBallAnchor2(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHingeAnchor, const char *, 2, 2,
	"() "
	"Get ball Anchor") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetHingeAnchor(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHingeAnchor2, const char *, 2, 2,
	"() "
	"Get ball Anchor2") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetHingeAnchor2(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHingeAxis, const char *, 2, 2,
	"() "
	"Get ball Axis") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetHingeAxis(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHingeParam, F32, 3, 3,
	"(param) "
	"Get hinge parameter") {

	argc; argv;

	return dJointGetHingeParam(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, GetHingeAngle, F32, 2, 2,
	"() "
	"Get hinge angle") {

	return dJointGetHingeAngle(object->joint);
}

ConsoleMethod(tdJoint, GetHingeAngleRate, F32, 2, 2,
	"() "
	"Get Hinge Angle Rate") {

	return dJointGetHingeAngleRate(object->joint);
}

ConsoleMethod(tdJoint, GetSliderPosition, F32, 2, 2,
	"() "
	"Get Slider Position") {

	return dJointGetSliderPosition(object->joint);
}

ConsoleMethod(tdJoint, GetSliderPositionRate, F32, 2, 2,
	"() "
	"Get Slider Position Rate") {

	return dJointGetSliderPositionRate(object->joint);
}

ConsoleMethod(tdJoint, GetSliderAxis, const char *, 2, 2,
	"() "
	"Get Slider Axis") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetSliderAxis(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetSliderParam, F32, 3, 3,
	"(param) "
	"Get Slider parameter") {

	argc; argv;

	return dJointGetSliderParam(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, GetHinge2Anchor, const char *, 2, 2,
	"() "
	"Get Hinge2 Anchor") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetHinge2Anchor(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHinge2Anchor2, const char *, 2, 2,
	"() "
	"Get Hinge2 Anchor2") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetHinge2Anchor2(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHinge2Axis1, const char *, 2, 2,
	"() "
	"Get Hinge2 Axis") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetHinge2Axis1(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHinge2Axis2, const char *, 2, 2,
	"() "
	"Get Hinge2 Axis2") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetHinge2Axis2(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetHinge2Param, F32, 3, 3,
	"(param) "
	"Get Hinge2 parameter") {

	argc; argv;

	return dJointGetHinge2Param(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, GetHinge2Angle1, F32, 2, 2,
	"() "
	"Get Hinge2 angle1") {

	return dJointGetHinge2Angle1(object->joint);
}

ConsoleMethod(tdJoint, GetHinge2Angle1Rate, F32, 2, 2,
	"() "
	"Get Hinge2 angle1Rate") {

	return dJointGetHinge2Angle1Rate(object->joint);
}

ConsoleMethod(tdJoint, GetHinge2Angle2Rate, F32, 2, 2,
	"() "
	"Get Hinge2 angle2Rate") {

	return dJointGetHinge2Angle2Rate(object->joint);
}

ConsoleMethod(tdJoint, GetUniversalAnchor, const char *, 2, 2,
	"() "
	"Get Universal Anchor") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetUniversalAnchor(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetUniversalAnchor2, const char *, 2, 2,
	"() "
	"Get Universal Anchor2") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetUniversalAnchor2(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetUniversalAxis1, const char *, 2, 2,
	"() "
	"Get Universal Axis1") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetUniversalAxis1(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetUniversalAxis2, const char *, 2, 2,
	"() "
	"Get Universal Axis2") {

	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetUniversalAxis2(object->joint, a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetUniversalParam, F32, 3, 3,
	"(param) "
	"Get Universal parameter") {

	argc; argv;

	return dJointGetUniversalParam(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, GetUniversalAngle1, F32, 2, 2,
	"() "
	"Get Universal angle1") {

	return dJointGetUniversalAngle1(object->joint);
}

ConsoleMethod(tdJoint, GetUniversalAngle2, F32, 2, 2,
	"() "
	"Get Universal angle2") {

	return dJointGetUniversalAngle2(object->joint);
}

ConsoleMethod(tdJoint, GetUniversalAngle1Rate, F32, 2, 2,
	"() "
	"Get Universal angle1Rate") {

	return dJointGetUniversalAngle1Rate(object->joint);
}

ConsoleMethod(tdJoint, GetUniversalAngle2Rate, F32, 2, 2,
	"() "
	"Get Universal angle2Rate") {

	return dJointGetUniversalAngle2Rate(object->joint);
}

ConsoleMethod(tdJoint, GetAMotorNumAxes, S32, 2, 2,
	"() "
	"Get number of axes on Angular Motor") {

	return dJointGetAMotorNumAxes(object->joint);
}

ConsoleMethod(tdJoint, GetAMotorAxis, const char *, 3, 3,
	"(anum) "
	"Get Angular Motor Axis") {

	argc;argc;
	dVector3 a;
	char *ret = Con::getReturnBuffer(256);

	dJointGetAMotorAxis(object->joint, dAtoi(argv[2]), a);

	dSprintf(ret, 256, "%f %f %f", a[0], a[1], a[2]);

	return ret;
}

ConsoleMethod(tdJoint, GetAMotorAxisRel, S32, 3, 3,
	"(anum) "
	"Get Angular Motor Axis") {

	argc;argv;
	return dJointGetAMotorAxisRel(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, GetAMotorAngle, F32, 3, 3,
	"(anum) "
	"Get Angular Motor Axis") {

	argc;argv;
	return dJointGetAMotorAngle(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, GetAMotorAngleRate, F32, 3, 3,
	"(anum) "
	"Get Angular Motor Axis Rate") {

	argc;argv;
	return dJointGetAMotorAngleRate(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, GetAMotorParam, F32, 3, 3,
	"(param) "
	"Get Angular Motor Parameter") {

	argc;argv;
	return dJointGetAMotorParam(object->joint, dAtoi(argv[2]));
}

ConsoleMethod(tdJoint, dJointGetAMotorMode, S32, 2, 2,
	"(anum) "
	"Get Angular Motor Mode") {

	return dJointGetAMotorMode(object->joint);
}

ConsoleFunction(BodiesAreConnected, S32, 4, 4,
    "(body1, body2) "
    "See if two Bodies are connected") {

    argc; argv;
	dBodyID b1,b2;

	b1 = ((tdBody *)Sim::findObject(dAtoi(argv[2])))->body;
	b2 = ((tdBody *)Sim::findObject(dAtoi(argv[3])))->body;
	if(NULL == b1 || NULL == b2) {
		return 0;
	}

	return dAreConnected(b1,b2);
}

ConsoleFunction(BodiesAreConnectedExcluding, S32, 5, 5,
    "(body1, body2, joint_type) "
    "See if two Bodies are connected") {

    argc; argv;
	dBodyID b1,b2;

	b1 = ((tdBody *)Sim::findObject(dAtoi(argv[2])))->body;
	b2 = ((tdBody *)Sim::findObject(dAtoi(argv[3])))->body;
	if(NULL == b1 || NULL == b2) {
		return 0;
	}

	return dAreConnectedExcluding(b1,b2,dAtoi(argv[4]));
}

ConsoleMethod(tdJoint, GetBody, S32, 3, 3,
    "(index) "
    "Get a body attached to joint") {

    argc; argv;

	if(0 == dAtoi(argv[2])) {
		return object->body1;
	} else {
		return object->body2;
	}
}


/* TODO


dJointID dJointCreateContact (dWorldID, dJointGroupID, const dContact *);

void dJointSetData (dJointID, void *data);
void *dJointGetData (dJointID);

void dJointSetFeedback (dJointID, dJointFeedback *);
dJointFeedback *dJointGetFeedback (dJointID);
*/
