// ODEShape

datablock ODEShapeData(ODEBoulderData)
{
	shapeFile = "./boulder.dts";
	category = "Boulders";
	emap = true;
};

function ODEShapeData::create(%data)
{
	// The mission editor invokes this method when it wants to create
	// an object of the given datablock type.
	// Good thing torque doesn't garbage collect, because this
	// is sort of a recursive data structure. Or, uh, something.
	// *ahem*

	%obj = new ODEShape() {
		datablock = %data;
		contactgroup = $odecollisionjg;
		worldsim = $odeworld;
	};

	%odemass = new tdMass() {
		datablock = odemassdata;
	};
	%odemass.SetSphereTotal(3, 15);
	%odeobj = new tdBody() {
		datablock = odebodydata;
		worldsim = $odeworld;
		shapeid = %obj;
	};
	%odeobj.SetMass(%odemass);
	%obj.odeobj = %odeobj;

	return %obj;
}
