function setupODE() {
	createODEdatablocks();

	$odecollisionjg = new tdJointGroup() { // Used for contact joints
		datablock = odejointgroupdata;
	};

	// Some sane defaults are pulled from defaults.cs
	$odeworld = new tdWorld() {
		contactjointgroup = $odecollisionjg; // Automatically on tick
		datablock = odeworlddata;
	};
	echo("$odeworld:" SPC $odeworld);

	MissionCleanup.Add($odeworld);
	MissionCleanup.Add($odecollisionjg);

	new SimGroup(ContactGroupCleanup); // used if not autocontacting
	MissionCleanup.Add(ContactGroupCleanup);
}

function shutdownODE() {
}

function createODEdatablocks() {
	// These exist for torquish craziness. The name= doesn't
	//   need to exist for ODE's benefit, but Torque expects datablocks
	//   to contain at least *something*
	// This might be a sensible place to put constants in future.
	//   But for the time being, those sliders in the gui are just
	//   too damn cool.

	datablock tdWorldData(odeworlddata) {
		name="World";
	};

	datablock tdBodyData(odebodydata) {
		name="Body";
	};

	datablock tdJointData(odejointdata) {
		name="Joint";
	};

	datablock tdContactData(odecontactdata) {
		name="Contact";
	};

	datablock tdJointGroupData(odejointgroupdata) {
		name="JointGroup";
	};

	datablock tdMassData(odemassdata) {
		name="Mass";
	};
}
