function serverCmdnewlink(%client) {
	if(!isObject(odechain)) {
		new ScriptObject(odechain) {
			links=0;
		};
		odechain.jointgroup = new tdJointGroup() { datablock = odejointgroupdata; };
		echo("Created chain:" SPC odechain);
		MissionCleanup.Add(odechain.jointgroup);
		MissionCleanup.Add(odechain);
		createlink(0);
	} else {
		odechain.links++;
		createlink(odechain.links);
	}
}

function createlink(%idx)
{
	echo("Creating link" SPC %idx);
	
	%obj = new ODEShape() {
		datablock = ODEBoulderData;
		contactgroup = $odecollisionjg;
		worldsim = $odeworld;
		disablecollisions = true;
	};

	%odemass = new tdMass() {
		datablock = odemassdata;
	};
	%odemass.SetSphereTotal(3, 1);
	%odeobj = new tdBody() {
		datablock = odebodydata;
		worldsim = $odeworld;
		shapeid = %obj;
	};
	%odeobj.SetMass(%odemass);
	%obj.odeobj = %odeobj;

	%odeobj.SetPosition(370,147,260-%idx*4);

	MissionCleanup.Add(%obj);
	MissionCleanup.Add(%odemass);
	MissionCleanup.Add(%odeobj);

	if(!isObject(odechain)) {
		echo("Can't find odechain [uhwhat?]");
		return;
	}
	
	if(%idx == 0) { // prevobj; the previous link in the chain.
		%prevobj = 0;
	} else {
		%prevobj = odechain.chainpiece[%idx-1];
	}

	%jnt = new tdJoint() {
		datablock = odejointdata;
	};
	%jnt.CreateBall($odeworld, odechain.jointgroup);
	%jnt.Attach(%prevobj, %odeobj);
	echo("Attached:" SPC %prevobj SPC "to" SPC %obj SPC "with joint" SPC %jnt);
	%jnt.SetBallAnchor(370,147,260-%idx*4+2);

	odechain.chainpiece[%idx] = %odeobj;
	odechain.chainlink[%idx] = %jnt;

	MissionCleanup.Add(%jnt);
}

function createchain(%chainlinks)
{
	for(%i=0;%i<%chainlinks;%i++) {
		createlink(%i);
	}
}
