//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// Load up common script base
loadDir("common");


//-----------------------------------------------------------------------------
// Package overrides to initialize the mod.
package ODEScriptPackage {

function onStart()
{
   Parent::onStart();
   echo("\n--------- Initializing MOD: ODEScript ---------");

//-----------------------------------------------------------------------------
// Load up defaults console values.

    $Pref::ignoreDSOs = 1;
    // Default console values
    exec("./physicsdefaults.cs");
    exec("./physicsprefs.cs");

   // Load the scripts that start it all...
   exec("./client/init.cs");
   exec("./server/init.cs");

   // Server gets loaded for all sessions, since clients
   // can host in-game servers.
   initServer();
}

function onExit()
{
   echo("Exporting physics prefs");
   export("$pref::ODEPhysics::*", "./physicsprefs.cs", False);

   Parent::onExit();
}

}; // Client package
activatePackage(ODEScriptPackage);
