//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// List of master servers to query, each one is tried in order
// until one responds
$Pref::Server::RegionMask = 2;
$pref::Master[0] = "2:master.garagegames.com:28002";

// Information about the server
$Pref::Server::Name = "Torque TTB Server";
$Pref::Server::Info = "This is a Torque Game Engine Test Server.";

// The connection error message is transmitted to the client immediatly
// on connection, if any further error occures during the connection
// process, such as network traffic mismatch, or missing files, this error
// message is display. This message should be replaced with information
// usefull to the client, such as the url or ftp address of where the
// latest version of the game can be obtained.
$Pref::Server::ConnectionError =
   "You do not have the correct version of the Torque Game Engine or "@
   "the related art needed to connect to this server, please contact "@
   "the server operator to obtain the latest version of this game.";

// The network port is also defined by the client, this value 
// overrides pref::net::port for dedicated servers
$Pref::Server::Port = 28000;

// If the password is set, clients must provide it in order
// to connect to the server
$Pref::Server::Password = "";

// Password for admin clients
$Pref::Server::AdminPassword = "";

// Misc server settings.
$Pref::Server::MaxPlayers = 64;
$Pref::Server::FloodProtectionEnabled = 1;
$Pref::Server::MaxChatLen = 120;



// World Error Reduction Parameter
$pref::ODEPhysics::Server::WorldERP = 0.8;

// World Constraint Force Mixing
$pref::ODEPhysics::Server::WorldCFM = 0.2;

// Three world gravity Co-ods
$pref::ODEPhysics::Server::WorldGravityX = 0;
$pref::ODEPhysics::Server::WorldGravityY = 0;
$pref::ODEPhysics::Server::WorldGravityZ = -9;


// From here down is primarily used in ODEShape

// Joint Error Reduction Parameter
$pref::ODEPhysics::Server::ContactERP = 0.9;

// Joint Constraint Force Mixing
$pref::ODEPhysics::Server::ContactCFM = 0.1;

// Contact joint bounce
$pref::ODEPhysics::Server::ContactBounce = 0.05;

// Damping; Set to Zero to disable. Positive numbers will add energy
// to the system. Don't do that.
$pref::ODEPhysics::Server::DampingFactor = -0.2;

// Set to non-zero to use Contact{ERP,CFM} instead of World{ERP,CFM}
$pref::ODEPhysics::Server::SoftContact = 1;

// Unset this if you want to create contact joints yourself. The
// salient callback will still be called, but you don't need to do
// joint stuff in there
$pref::ODEPhysics::Server::AutoContacts = 1;

// Friction for contact joints
$pref::ODEPhysics::Server::ContactMu = 75;

// Tolerance in collisions
$pref::ODEPhysics::Server::Tolerance = 1.2;
