// ODEShape

datablock ODEShapeData(ODEBoulderData)
{
	shapeFile = "./boulder.dts";
	category = "Boulders";
	emap = true;
};

function ODEShapeData::create(%data)
{
	// The mission editor invokes this method when it wants to create
	// an object of the given datablock type.
	// Good thing torque doesn't garbage collect, because this
	// is sort of a recursive data structure. Or, uh, something.
	// *ahem*

	%obj = new ODEShape() {
		datablock = %data;
		contactgroup = $odecollisionjg;
		worldsim = $odeworld;
	};

	%odemass = new tdMass() {
		datablock = odemassdata;
	};
	%odemass.SetSphereTotal(3, 15);
	%odeobj = new tdBody() {
		datablock = odebodydata;
		worldsim = $odeworld;
		shapeid = %obj;
	};
	%odeobj.SetMass(%odemass);
	%obj.odeobj = %odeobj;

	return %obj;
}



// ExampleCollider

datablock ExampleColliderData(MyExampleColliderData)
{
	 category = "Boulders";
	 shapefile = "./boulder.dts";
	 emap = true;
};

function ExampleColliderData::create(%data)
{
	// The mission editor invokes this method when it wants to create
	// an object of the given datablock type.

	%obj = new ExampleCollider() {
		datablock = %data;
	};

	%odemass = new tdMass() {
		datablock = odemassdata;
	};
	%odemass.SetSphereTotal(5, 10);
	%odeobj = new tdBody() {
		datablock = odebodydata;
		worldsim = $odeworld;
		shapeid = %obj;
	};
	%odeobj.SetMass(%odemass);
	%obj.odeobj = %odeobj;

	return %obj;
}


// ExampleShapeBase

datablock ExampleShapeBaseData(BoulderShapeData)
{
	shapeFile = "./boulder.dts";
	category = "Boulders";
	emap = true;
};

function ExampleShapeBaseData::create(%data)
{
	// The mission editor invokes this method when it wants to create
	// an object of the given datablock type.
	%obj = new ExampleShapeBase() {
		dataBlock = %data;
	};
	return %obj;
}

// RigidShape 

datablock RigidShapeData(RigidBoulder)
{	
	category = "Boulders";
	shapeFile = "./boulder.dts";
	emap = true;

	// Rigid Body
	mass = 500;
	massCenter = "0 0 0";	 // Center of mass for rigid body
	massBox = "0 0 0";			// Size of box used for moment of inertia,
										// if zero it defaults to object bounding box
	drag = 0.2;					 // Drag coefficient
	bodyFriction = 0.2;
	bodyRestitution = 0.1;
	minImpactSpeed = 5;		  // Impacts over this invoke the script callback
	softImpactSpeed = 5;		 // Play SoftImpact Sound
	hardImpactSpeed = 15;		// Play HardImpact Sound
	integration = 4;			  // Physics integration: TickSec/Rate
	collisionTol = 0.1;		  // Collision distance tolerance
	contactTol = 0.1;			 // Contact velocity tolerance
	
	minRollSpeed = 10;
	
	maxDrag = 0.5;
	minDrag = 0.01;

	triggerDustHeight = 1;
	dustHeight = 10;

	dragForce = 0.05;
	vertFactor = 0.05;

	normalForce = 0.05;
	restorativeForce = 0.05;
	rollForce = 0.05;
	pitchForce = 0.05;
};


function RigidShapeData::create(%data)
{
	// The mission editor invokes this method when it wants to create
	// an object of the given datablock type.
	%obj = new RigidShape() {
		dataBlock = %data;
	};
	return %obj;
}
