//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Load up common script base
//-----------------------------------------------------------------------------
loadDir("common");


//-----------------------------------------------------------------------------
// Load Client Preferences.
//-----------------------------------------------------------------------------
exec("./defaults.cs");
exec("./client/prefs.cs");


//-----------------------------------------------------------------------------
// T2D Package.
//-----------------------------------------------------------------------------
package JM
{
	// Start-up.
	function onStart()
	{
		Parent::onStart();
		echo("\n--------- Initializing MOD: JM ---------");
		
		// Load Client Scripts.
		exec("./client/client.cs");
		exec("./jmlib/main.cs");
		
		// Initialise Client.
		initialiseClient();
	}
	
	// Shutdown.
	function onExit()
	{
		// Destroy Client.
		destroyClient();
		
		echo("Exporting client prefs");
		export("$pref::*", "./client/prefs.cs", false);
		
		echo("Exporting client config");
		if (isObject(moveMap))
		  moveMap.save("./client/config.cs", false);
		
		// Call Parent.		
		Parent::onExit();
	}
	
	function quitapp() { quit(); }
	
};


//-----------------------------------------------------------------------------
// Activate Package.
//-----------------------------------------------------------------------------
activatePackage(JM);

