//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// --------------------------------------------------------------------
// Initialise Client.
// --------------------------------------------------------------------
function initialiseClient()
{
	// Initialise Base Client.
	InitBaseClient();
	
	// Key-Bindings.
	GlobalActionMap.bind(keyboard, tilde, ToggleConsole);
	GlobalActionMap.bindCmd(keyboard, "alt enter", "", "toggleFullScreen();");
	
		
	// Initialise Canvas.
	InitCanvas("T2D");

	
	
	// Load-up GUIs.
	exec("./mainScreenGui.gui");
	exec("~/ui/main.cs");
	
	// Set GUI.
	Canvas.setContent(mainScreenGui);
	// Set Cursor.
	Canvas.setCursor(DefaultCursor);
	
   // Setup Scene.
	setupT2DScene();
}


// --------------------------------------------------------------------
// Destroy Client.
//
// Here we destroy the SceneGraph.
// --------------------------------------------------------------------
function destroyClient()
{
	// Destroy fxSceneGraph2D.
	if ( isObject(t2dSceneGraph) )
		t2dSceneGraph.delete();	
}


// --------------------------------------------------------------------
// Setup T2D Scene.
// --------------------------------------------------------------------
function setupT2DScene()
{
	// Create fxSceneGraph2D.
	new fxSceneGraph2D(t2dSceneGraph);
	
	// Associate Scenegraph with Window.
	sceneWindow2D.setSceneGraph( t2dSceneGraph );
	
	sceneWindow2D.setCurrentCameraPosition( "180 150 360 300" );

	
	// ************************************************************************
	//
	// Add your custom code here...
	//
	// ************************************************************************
	
	createimagemaps();


	$jm = new ScriptObject(JMLib);

	for(%i=0;%i<$BMAX;%i++) {
		$jmball[%i] = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
		$jmball[%i].setsize("20 20");
		$jmball[%i].setPosition($jm.b[%i].gx SPC $jm.b[%i].gy);
		$jmball[%i].setImageMap(ballImageMap);
		$jmball[%i].setVisible(0);
		// ballEffect($jmball[%i], "0 0", 0);
	}

	$balldiam = (20*$jm.dpm/$DW);
	for(%i=0;%i<$jm.balln;%i++) {
		$jmball[%i].setsize($balldiam SPC $balldiam);
		$jmball[%i].setVisible(1);
		 //$jmball[%i].ef.playEffect();
	}

//	for(%i=0;%i<5;%i++) {
//		$armsegment[%i] = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
//		$armsegment[%i].setsize("1 1");
//		$armsegment[%i].setPosition($jm.b[%i].gx SPC $jm.b[%i].gy);
//		$armsegment[%i].setImageMap(armpieceImageMap);
//	}

	$jmlhand = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
	$jmlhand.setsize($balldiam SPC $balldiam);
	$jmlhand.setPosition($jm.lhand.gx SPC $jm.lhand.gy);
	$jmlhand.setImageMap(lhandImageMap);

	$jmrhand = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
	$jmrhand.setsize($balldiam SPC $balldiam);
	$jmrhand.setPosition($jm.rhand.gx SPC $jm.rhand.gy);
	$jmrhand.setImageMap(rhandImageMap);
	
}

function ballEffect(%ball, %position, %angle) {
	%ball.ef = new fxParticleEffect2D() { scenegraph = t2dSceneGraph; };
	%ball.ef.loadEffect("~/client/effects/steam.eff");
	%ball.ef.mount( %ball, %position, 0, false );
	%ball.ef.setRotation( %angle );
}

function updatejmscreen() {
	for(%i=0;%i<$jm.balln;%i++) {
		$jmball[%i].setPosition($jm.b[%i].gx SPC $jm.b[%i].gy);
		// echo("Ball" SPC %i SPC $jm.b[%i].gx SPC $jm.b[%i].gy);
	}
	$jmlhand.setPosition($jm.lhand.gx SPC ($jm.lhand.gy + $balldiam/2));
	$jmrhand.setPosition($jm.rhand.gx SPC ($jm.rhand.gy + $balldiam/2));

	OnScreenStatus.setValue("Site:" SPC $jm.getSite() SPC "   Style:" SPC $jm.getStyle() SPC "   Balls:" SPC $jm.balln);

//	%a = $jm.ap;
//	for(%i=0;%i<5;%i++) {
//		%len = mSqrt(squared(%a.rx[i] - %a.rx[i+1]) + squared(%a.ry[i] - %a.ry[i+1]));
//		%theta = 180 + mAtan(%a.rx[i] - %a.rx[i+1], %a.ry[i] - %a.ry[i+1]);
//		echo("len" SPC %len SPC "theta" SPC %theta);
//		$armsegment[%i].setSize(%len SPC "2");
//		$armsegment[%i].setRotation(%theta);
//		$armsegment[%i].setPosition((%a.rx[i] + %a.rx[i+1])/2 SPC (%a.ry[i] + %a.ry[i+1])/2);
//	}
}

function changesite(%name, %site, %hr, %dr) {
	%old_do_that_thing = $DO_THAT_THING;
	$DO_THAT_THING = 0;
	$jm.reset();
	if($jm.setPattern(%name, %site, %hr, %dr) != 0) {
		// Failed. JM should have put up a useful error message, so ignore it here
		$jm.setPatternDefault();
	}
	$jm.setStyleDefault();
	$jm.startJuggle();

	$balldiam = (20*$jm.dpm/$DW);
	for(%i=0;%i<$jm.balln;%i++) {
		$jmball[%i].setsize($balldiam SPC $balldiam);
		$jmball[%i].setVisible(1);
	}
	$jmrhand.setsize($balldiam SPC $balldiam);
	$jmlhand.setsize($balldiam SPC $balldiam);
	for(%i=$jm.balln;%i<$BMAX;%i++) {
		$jmball[%i].setVisible(0);
	}
	$DO_THAT_THING = %old_do_that_thing;
}

function tj() {
	// tickjuggle
	if($DO_THAT_THING != 0) {
		$jm.doJuggle();
		updatejmscreen();
		schedule(30, 0, tj);
	}
}

function createimagemaps() {
	datablock fxImageMapDatablock2D(ballImageMap) {
		mode = full;
		textureName = "~/client/images/ball";
	};

	datablock fxImageMapDatablock2D(rhandImageMap) {
		mode = full;
		textureName = "~/client/images/rhand";
	};

	datablock fxImageMapDatablock2D(lhandImageMap) {
		mode = full;
		textureName = "~/client/images/lhand";
	};
}
$DO_THAT_THING = 1;
tj();
