//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------



// --------------------------------------------------------------------
// Standard Collision Material.
// --------------------------------------------------------------------
datablock fxCollisionMaterialDatablock2D(immovableMaterial)
{
	friction = 0.0;
	restitution = 0.0;
	relaxation = 0.5;
	density = 0.0;
	forceScale = 0;
	damping = 0.0;
};


// --------------------------------------------------------------------
// Projectile Collision Material.
// --------------------------------------------------------------------
datablock fxCollisionMaterialDatablock2D(projectileMaterial)
{
	friction = 0.0;
	restitution = 0.4;
	relaxation = 0.5;
	density = 0.01;
	forceScale = 20;
	damping = 0.0;
};


// --------------------------------------------------------------------
// Standard Collision Material.
// --------------------------------------------------------------------
datablock fxCollisionMaterialDatablock2D(standardMaterial)
{
	friction = 0.6;
	restitution = 0.0;
	relaxation = 0.5;
	density = 0.01;
	forceScale = 1;
	damping = 0.1;
};


// --------------------------------------------------------------------
// Brick ImageMap.
// --------------------------------------------------------------------
datablock fxChunkedImageDatablock2D(brickImage)
{
	mode = full;
	textureName = "~/client/images/brick";
};


// --------------------------------------------------------------------
// Ring ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(ringImageMap)
{
	mode = full;
	textureName = "~/client/images/ring";
};


// --------------------------------------------------------------------
// Font1 ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(font1ImageMap)
{
	mode = cell;
	cellWidth = 16;
	cellHeight = 16;	
	textureName = "~/client/images/font1";
};


// --------------------------------------------------------------------
// Font2 ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(font2ImageMap)
{
	mode = cell;
	cellWidth = 16;
	cellHeight = 16;	
	textureName = "~/client/images/font2";
};



// --------------------------------------------------------------------
// GG Logo ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(ggLogoImageMap)
{
	mode = full;
	textureName = "~/client/images/ggLogo";
};


// --------------------------------------------------------------------
// TileMap ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(tileMapImageMap)
{
	mode = cell;
	cellWidth = 128;
	cellHeight = 128;	
	textureName = "~/client/images/tileMap";
};


// --------------------------------------------------------------------
// Crosshair ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(crosshairImageMap)
{
	mode = full;
	textureName = "~/client/images/crosshair";
};


// --------------------------------------------------------------------
// Ship ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(shipImageMap)
{
	mode = full;
	textureName = "~/client/images/ship";
};


// --------------------------------------------------------------------
// Asteroids ImageMap.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(asteroidsImageMap)
{
	mode = cell;
	cellWidth = 128;
	cellHeight = 128;		
	textureName = "~/client/images/asteroids";
};


// --------------------------------------------------------------------
// Lightning.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(lightningImageMap)
{
	mode = cell;
	cellWidth = 64;
	cellHeight = 128;		
	textureName = "~/client/images/lightning";
};


// --------------------------------------------------------------------
// Backgrounds.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(skyImageMap)
{
	mode = full;
	textureName = "~/client/images/back1";
};

datablock fxImageMapDatablock2D(mountainsImageMap)
{
	mode = full;
	textureName = "~/client/images/back2";
};

datablock fxImageMapDatablock2D(hillsImageMap)
{
	mode = full;
	textureName = "~/client/images/back3";
};

datablock fxImageMapDatablock2D(valleyImageMap)
{
	mode = full;
	textureName = "~/client/images/back4";
};





// --------------------------------------------------------------------
// Particle ImageMaps.
// --------------------------------------------------------------------
datablock fxImageMapDatablock2D(particles1ImageMap)
{
	mode = cell;
	cellWidth = 64;
	cellHeight = 64;	
	textureName = "~/client/images/particles1";
};

datablock fxImageMapDatablock2D(particles2ImageMap)
{
	mode = cell;
	cellWidth = 128;
	cellHeight = 128;	
	textureName = "~/client/images/particles2";
};

datablock fxImageMapDatablock2D(particles3ImageMap)
{
	mode = cell;
	cellWidth = 128;
	cellHeight = 128;	
	textureName = "~/client/images/particles3";
};

datablock fxImageMapDatablock2D(particles4ImageMap)
{
	mode = cell;
	cellWidth = 64;
	cellHeight = 64;	
	textureName = "~/client/images/particles4";
};

datablock fxImageMapDatablock2D(particles5ImageMap)
{
	mode = cell;
	cellWidth = 64;
	cellHeight = 64;	
	textureName = "~/client/images/particles5";
};

datablock fxImageMapDatablock2D(particles6ImageMap)
{
	mode = cell;
	cellWidth = 64;
	cellHeight = 64;	
	textureName = "~/client/images/particles6";
};

datablock fxImageMapDatablock2D(flamesImageMap)
{
	mode = cell;
	cellWidth = 32;
	cellHeight = 32;	
	textureName = "~/client/images/flames";
};

datablock fxImageMapDatablock2D(raindropImageMap)
{
	mode = cell;
	cellWidth = 32;
	cellHeight = 32;	
	textureName = "~/client/images/raindrop";
};

datablock fxImageMapDatablock2D(smallBubbleImageMap)
{
	mode = full;
	textureName = "~/client/images/smallbubble";
};

datablock fxImageMapDatablock2D(beamImageMap)
{
	mode = full;
	textureName = "~/client/images/beam";
};

// --------------------------------------------------------------------
// Flame Animation.
// --------------------------------------------------------------------
datablock fxAnimationDatablock2D(flamesAnimation)
{
	imageMap = flamesImageMap;
	animationFrames = "0 1 2 3";
	animationTime = 0.3;
	animationCycle = true;
	randomStart = true;
};


// --------------------------------------------------------------------
// Lightning Animation.
// --------------------------------------------------------------------
datablock fxAnimationDatablock2D(lightningAnimation)
{
	imageMap = lightningImageMap;
	animationFrames = "0 1 2 3 1 2 3";
	animationTime = 0.3;
	animationCycle = true;
	randomStart = true;
};


// --------------------------------------------------------------------
// Lightning Animation.
// --------------------------------------------------------------------
datablock fxAnimationDatablock2D(matrixAnimation)
{
	imageMap = font1ImageMap;
	animationFrames = "";
	animationTime = 5;
	animationCycle = true;
	randomStart = true;
};

