//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// --------------------------------------------------------------------
// Initialise Client.
// --------------------------------------------------------------------
function initialiseClient()
{
	// Initialise Base Client.
	InitBaseClient();
	
	// Key-Bindings.
	GlobalActionMap.bind(keyboard, tilde, ToggleConsole);
	GlobalActionMap.bindCmd(keyboard, "alt enter", "", "toggleFullScreen();");
	
		
	// Initialise Canvas.
	InitCanvas("T2D");

	
	// ************************************************************************
	// Load-up Demo Datablocks.
	// NOTE:-	Remove this is you're not interested in running the demos
	//			or any or the default datablocks.
	// ************************************************************************
	exec("./demoDatablocks.cs");
	
	
	
	// Load-up Datablocks.	
	exec("./datablocks.cs");
	// Load-up GUIs.
	exec("./mainScreenGui.gui");
	exec("~/ui/RandomPattern.gui");
	
	// Set GUI.
	Canvas.setContent(mainScreenGui);
	// Set Cursor.
	Canvas.setCursor(DefaultCursor);
	
   // Setup Scene.
	setupT2DScene();
}


// --------------------------------------------------------------------
// Destroy Client.
//
// Here we destroy the SceneGraph.
// --------------------------------------------------------------------
function destroyClient()
{
	// Destroy fxSceneGraph2D.
	if ( isObject(t2dSceneGraph) )
		t2dSceneGraph.delete();	
}


// --------------------------------------------------------------------
// Setup T2D Scene.
// --------------------------------------------------------------------
function setupT2DScene()
{
	// Create fxSceneGraph2D.
	new fxSceneGraph2D(t2dSceneGraph);
	
	// Associate Scenegraph with Window.
	sceneWindow2D.setSceneGraph( t2dSceneGraph );
	
	sceneWindow2D.setCurrentCameraPosition( "180 150 360 300" );

	
	// ************************************************************************
	//
	// Add your custom code here...
	//
	// ************************************************************************
	
	datablock fxImageMapDatablock2D(ballImageMap) {
		mode = full;
		textureName = "~/client/images/ball";
	};

	datablock fxImageMapDatablock2D(handImageMap) {
		mode = full;
		textureName = "~/client/images/hand";
	};

	datablock fxImageMapDatablock2D(armpieceImageMap) {
		mode = full;
		textureName = "~/client/images/armpiece";
	};


	$jm = new ScriptObject(JMLib);

	for(%i=0;%i<$jm.balln;%i++) {
		$jmball[%i] = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
		$jmball[%i].setsize("20 20");
		$jmball[%i].setPosition($jm.b[%i].gx SPC $jm.b[%i].gy);
		$jmball[%i].setImageMap(ballImageMap);
		ballEffect($jmball[%i], "0 0", 0);
	}

//	for(%i=0;%i<5;%i++) {
//		$armsegment[%i] = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
//		$armsegment[%i].setsize("1 1");
//		$armsegment[%i].setPosition($jm.b[%i].gx SPC $jm.b[%i].gy);
//		$armsegment[%i].setImageMap(armpieceImageMap);
//	}

	$jmlhand = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
	$jmlhand.setsize("20 20");
	$jmlhand.setPosition($jm.lhand.gx SPC $jm.lhand.gy);
	$jmlhand.setImageMap(handImageMap);

	$jmrhand = new fxStaticSprite2D() { scenegraph = t2dSceneGraph; };
	$jmrhand.setsize("20 20");
	$jmrhand.setPosition($jm.rhand.gx SPC $jm.rhand.gy);
	$jmrhand.setImageMap(handImageMap);
	
}

function ballEffect(%ball, %position, %angle) {
	%ef = new fxParticleEffect2D() { scenegraph = t2dSceneGraph; };
	%ef.loadEffect("~/client/effects/steam.eff");
	%ef.mount( %ball, %position, 0, false );
	%ef.setRotation( %angle );
	%ef.playEffect();
}

function updatejmscreen() {
	for(%i=0;%i<$jm.balln;%i++) {
		$jmball[%i].setPosition($jm.b[%i].gx SPC $jm.b[%i].gy);
		// echo("Ball" SPC %i SPC $jm.b[%i].gx SPC $jm.b[%i].gy);
	}
	$jmlhand.setPosition($jm.lhand.gx SPC $jm.lhand.gy);
	$jmrhand.setPosition($jm.rhand.gx SPC $jm.rhand.gy);

//	%a = $jm.ap;
//	for(%i=0;%i<5;%i++) {
//		%len = mSqrt(squared(%a.rx[i] - %a.rx[i+1]) + squared(%a.ry[i] - %a.ry[i+1]));
//		%theta = 180 + mAtan(%a.rx[i] - %a.rx[i+1], %a.ry[i] - %a.ry[i+1]);
//		echo("len" SPC %len SPC "theta" SPC %theta);
//		$armsegment[%i].setSize(%len SPC "2");
//		$armsegment[%i].setRotation(%theta);
//		$armsegment[%i].setPosition((%a.rx[i] + %a.rx[i+1])/2 SPC (%a.ry[i] + %a.ry[i+1])/2);
//	}
}

function tj() {
	// tickjuggle
	$jm.doJuggle();
	updatejmscreen();
	if($DO_THAT_THING != 0) {
		schedule(100, 0, tj);
	}
}

$DO_THAT_THING = 1;
tj();
