#include "console/console.h"
#include <stdlib.h>
#include <Carbon/Carbon.h>
#include <sys/sysctl.h>

//	We execute our AppleScript code to communicate with iTunes via the command line tool osascript.
#define ITUNESNEXT_TRACK "osascript -e 'tell application \"iTunes\"' -e 'next track' -e 'end tell' &"
#define ITUNESBACK_TRACK "osascript -e 'tell application \"iTunes\"' -e 'back track' -e 'end tell' &"
#define ITUNESPREVIOUS_TRACK "osascript -e 'tell application \"iTunes\"' -e 'previous track' -e 'end tell' &"
#define ITUNESPAUSE "osascript -e 'tell application \"iTunes\"' -e 'pause' -e 'end tell' &"
#define ITUNESPLAY "osascript -e 'tell application \"iTunes\"' -e 'play' -e 'end tell' &"
#define ITUNESPLAYPAUSE "osascript -e 'tell application \"iTunes\"' -e 'playpause' -e 'end tell' &"
#define ITUNESVOLUME_UP "osascript -e 'tell application \"iTunes\"' -e 'set currentVolume to sound volume' -e 'if currentVolume is greater than 90 then' -e 'set currentVolume to 100' -e 'end if' -e 'set sound volume to \(currentVolume + 10\)' -e 'end tell' &"
#define ITUNESVOLUME_DOWN "osascript -e 'tell application \"iTunes\"' -e 'set currentVolume to sound volume' -e 'if currentVolume is less than 10 then' -e 'set currentVolume to 0' -e 'end if' -e 'set sound volume to \(currentVolume - 10\)' -e 'end tell' &"

ConsoleFunction(iTunesNextTrack, void, 1, 1, "() Skip to Next Track") {
	system(ITUNESNEXT_TRACK);
}

ConsoleFunction(iTunesBackTrack, void, 1, 1, "() Skip to Start of Track") {
	system(ITUNESBACK_TRACK);
}

ConsoleFunction(iTunesPlay, void, 1, 1, "() Set iTunes playing") {
	system(ITUNESPLAY);
}

ConsoleFunction(iTunesPause, void, 1, 1, "() Set iTunes to pause") {
	system(ITUNESPAUSE);
}

ConsoleFunction(iTunesTogglePlayPause, void, 1, 1, "() Set iTunes to toggle play/pause") {
	system(ITUNESPLAYPAUSE);
}

ConsoleFunction(iTunesVolUp, void, 1, 1, "() Increase iTunes volume") {
	system(ITUNESVOLUME_UP);
}

ConsoleFunction(iTunesVolDown, void, 1, 1, "() Decrease iTunes volume") {
	system(ITUNESVOLUME_DOWN);
}

